<?php
/**
 * Joomla! Upgrade Helper
 */
/** ensure this file is being included by a parent file */
defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

$session =& JFactory::getSession();
switch(JRequest::getVar('target', 'patch')) {
	default:
	case 'patch':
		$details = $session->get('jupdateman_patchpackage');
		break;
	case 'full':
		$details = $session->get('jupdateman_fullpackage');
		break;
}
if(!is_object($details)) {
	$app =& JFactory::getApplication();
	$app->redirect('index.php?option=com_jupdateman&task=step1'); // back to step one if invalid session 
}
$url  = $details->url;
$file = $details->filename;
$size = $details->filesize;
$md5  = $details->md5;

@set_time_limit(0); // Make sure we don't timeout while downloading
$config =& JFactory::getConfig();
$tmp_path = $config->getValue('config.tmp_path');
$file_path = $tmp_path.DS.$file;
 
$params =& JComponentHelper::getParams('com_jupdateman');



if(!$params->get('cached_update', 0)) {
	$result = downloadFile($url,$file_path);
	if(is_object( $result )) {
		HTML_jupgrader::showError( 'Echec téléchargement: '. $result->message . '('. $result->number . ')</p>' );
		return false;
	}
} else {
	if(!file_exists($file_path)) {
		HTML_jupgrader::showError('Le fichier n\'exite pas et le mode cache est activé. Télécharger le fichier de mise à jour. <a href="'. $details->url .'" target="_blank">Cliquer ici pour télécharger l\'archive.</a> <br /><a href="index.php?option=com_jupdateman&task=step2">Recharger la page.</a>');
		return false;
	}
}

if(strlen($md5)) {
	if(md5_file($file_path) != $md5) {
		HTML_jupgrader::showError('Erreur: la somme MD5 ne correspond pas! Effacer et recommencer le téléchargement du fichier.');
		return false;
	}
} else {
	echo '<p>Attention: Le fichier Ce fichier n\'a pas un hachage MD5 pour valider!</p>';
}

$session->set('jupdateman_filename', $file);

?>
<p>Le fichier '<?php echo $file ?>' a été téléchargé depuis <a href="<?php echo $url ?>" target="_blank"><?php echo $url ?></a>.</p>
<p>Si vous êtes certain de vouloir utiliser ce pack, <a href="index.php?option=com_jupdateman&task=step3">vous pouvez continuer son installation &gt;&gt;&gt;</a></p>