<?php
/** ****************************************************************
 * This file is part of SecurityImages for Joomla!.
 *
 * SecurityImages is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.

 * Foobar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package		SecurityImages
 * @copyright	Copyright (C) 2004 - 2008 Cdric Walter. All rights reserved.
 *******************************************************************/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();



jimport('joomla.application.component.controller');

JLoader::import('class.logUtils', dirname( __FILE__ ));
JLoader::import('class.config', dirname( __FILE__ ));
JLoader::import('class.language', dirname( __FILE__ ));
//JLoader::import('class.SecurityImagesHelper', dirname( __FILE__ ));

/**
 * 
 */
class SecurityImagesAdminController extends JController
{

  var $langTag = "en-GB";
  
  
  /**
   * Custom Constructor
   */
  function __construct( $default = array())
  {
    parent::__construct( $default );
    $lang		=& JFactory::getLanguage();
    $this->langTag = $lang->getTag();
  }
  
  function about() {
    $file = dirname( __FILE__ ).DS.'manuals'.DS.$this->langTag.DS.'about.html';
    if (!file_exists($file)) {
       $file = dirname( __FILE__ ).DS.'manuals'.DS.'en-GB'.DS.'about.html';
    }
    
    $option = JRequest::getVar( 'option', '');
    $SecurityImagesConfig = & new SecurityImagesConfig();
    echo $SecurityImagesConfig->getContentOfFile($file, $option);
  }

  function developer() {
    $file = dirname( __FILE__ ).DS.'manuals'.DS.$this->langTag.DS.'developer.html';
    if (!file_exists($file)) {
       $file = dirname( __FILE__ ).DS.'manuals'.DS.'en-GB'.DS.'developer.html';
    }
    
    $option = JRequest::getVar( 'option', '');
    $SecurityImagesConfig = & new SecurityImagesConfig();
    echo $SecurityImagesConfig->getContentOfFile($file, $option);
  }

  function troubles() {
    $file = dirname( __FILE__ ) .DS.'manuals'.DS.$this->langTag.DS.'troubles.html';
    if (!file_exists($file)) {
       $file = dirname( __FILE__ ).DS.'manuals'.DS.'en-GB'.DS.'troubles.html';
    }
    
    $option = JRequest::getVar( 'option', '');
    $SecurityImagesConfig = & new SecurityImagesConfig();
    echo $SecurityImagesConfig->getContentOfFile($file, $option);
  }

  function aboutcore() {
    $file = dirname( __FILE__ ) .DS.'manuals'.DS.$this->langTag.DS.'about.html';
    if (!file_exists($file)) {
       $file = dirname( __FILE__ ) .DS.'manuals'.DS.'en-GB'.DS.'about.html';
    }
    $option = JRequest::getVar( 'option', '');
    $SecurityImagesConfig = & new SecurityImagesConfig();
    echo $SecurityImagesConfig->getContentOfFile($file, $option);
  }

  function general_settings() {
    include_once (dirname( __FILE__ ).DS.'config.securityimages.php');
    $securityImagesConfig = new SecurityImagesConfig();
    $option = JRequest::getVar( 'option', '');
    $securityImagesConfig->showGeneralConfig($option);
  }

  function checkSystem() {
    require_once (dirname( __FILE__ ) .DS.'class'.DS.'systeminfo.php');
    $securityImageSystemInfo = & new SecurityImageSystemInfo();
    $securityImageSystemInfo->checkSystem();
  }

  function savegeneralsettings() {
    $option = JRequest::getVar( 'option', '');
    $params_request = array (
			'securityImagesPlugins',
			'securityImagesPluginsVersion',
			'securityImagesDebug',
			'securitySwitchOffGlobally',
			'securityImagesUseInLogin',
			'securityImagesUseInRegistration',
			'securityImagesUseInSendNewPass',
			'securityImagesDeactivateReloadButton',
			'securityImagesDeactivateSoundButton',
			'securityImagesLogActive',
			'securityImagesLogAll',
			'securityImagesNotifyAdmin',
			'securityImagesLogSize',
			'securityImagesAdminEmail',
			'securityImagesLoggedInUserSwitchOff',
			'securityImagesDisplayAuthorBacklink',
            'securityImagesRegressionTestMode',
            'securityImagesInLogin',
    		'securityImagesInLoginModule',
            'securityImagesInRegister', 
            'securityImagesInResetPassword',
			'securityImagesInRemindMe', 
			'securityImagesInContact',
      		'securityImagesInConfirmResetPassword',
            'securityImagesInCompleteResetPassword');
    
			foreach ($params_request as $val) {
			  $$val = JRequest::getVar( $val, '');
			}
			$securityImagesConfig = new SecurityImagesConfig();
				
			$securityImagesConfig->saveGeneralConfig($option, $securityImagesPlugins,
			$securityImagesPluginsVersion, $securityImagesDebug,
			$securitySwitchOffGlobally, $securityImagesUseInLogin,
			$securityImagesUseInRegistration, $securityImagesUseInSendNewPass,
			$securityImagesDeactivateReloadButton, $securityImagesDeactivateSoundButton,
			$securityImagesLogActive, $securityImagesLogAll,
			$securityImagesNotifyAdmin, $securityImagesLogSize,
			$securityImagesAdminEmail, $securityImagesLoggedInUserSwitchOff,
			$securityImagesDisplayAuthorBacklink, $securityImagesRegressionTestMode,
			$securityImagesInLogin, $securityImagesInLoginModule, $securityImagesInRegister, $securityImagesInResetPassword,
            $securityImagesInRemindMe, $securityImagesInContact, $securityImagesInConfirmResetPassword,
            $securityImagesInCompleteResetPassword);
			
			SecurityImagesAdminController::general_settings();
  }

  function settings() {
    include_once (dirname( __FILE__ ) .DS.'config.securityimages.php');
    include_once (dirname( __FILE__ ) .DS.'pluginsA'.DS.$securityImagesPlugins.DS.$securityImagesPluginsVersion.DS.'adminpanel.php');
    $option = JRequest::getVar( 'option', '');

    showConfig($option);
  }
  
 function savesettings() {
    include_once (dirname( __FILE__ ) .DS.'config.securityimages.php');
    include_once (dirname( __FILE__ ) .DS.'pluginsA'.DS.$securityImagesPlugins.DS.$securityImagesPluginsVersion.DS.'adminpanel.php');
    $option = JRequest::getVar( 'option', '');
    
    savePluginSettings($option);
  }
  
  function showlogs() {
    $option = JRequest::getVar( 'option', '');
    $logUtils = & new LogUtils();
    $logUtils->showLogs($option);
  }

  function editgenerallanguage() {
    $option = JRequest::getVar( 'option', '');
    $securityImagesLanguage = new SecurityImagesLanguage();
    $securityImagesLanguage->showLanguage($option);
  }

  function editcorelanguage() {
    $option = JRequest::getVar( 'option', '');
    $securityImagesLanguage = new SecurityImagesLanguage();
    $securityImagesLanguage->showLanguage($option);
  }

  function savefile() {
    $option = JRequest::getVar( 'option', '');
    $filecontent = JRequest::getVar( 'filecontent', '', _MOS_ALLOWHTML);
    $file = JRequest::getVar( 'file', '');
    $securityImagesLanguage = new SecurityImagesLanguage();
    $securityImagesLanguage->saveLanguage($file, $filecontent, $option);
  }

  function checkLatest() {
    include_once (dirname( __FILE__ ) .DS. "config.securityimages.php");
    global $mainframe;
    $mainframe->redirect("http://www.waltercedric.com/updater.php?option=com_versions&catid=10&myVersion=$securityImagesVersionShort", "Redirecting You to www.waltercedric.com for checking latest version");
  }

  function getJoomlaPatches() {
    include_once (dirname( __FILE__ ) .DS. "config.securityimages.php");
    global $mainframe;
    $mainframe->redirect("http://www.waltercedric.com/updater.php?option=com_versions&catid=11", "Redirecting You to www.waltercedric.com for getting Joomla! patches");
  }
  
  
  function deleteSecurityImagesLogs() {
    $option = JRequest::getVar( 'option', '');
    $logUtils = & new LogUtils();
    $logUtils->emptyLogs();
    global $mainframe;
    $mainframe->redirect("index2.php?option=$option&task=showlogs", JText::_('SECURITY IMAGES LOG ARE NOW DELETED'));
  }

  function exportToCSV() {
    $logUtils = & new LogUtils();
    $logUtils->exportToCSV();
    exit;
  }

  function exportToHTML() {
    $logUtils = & new LogUtils();
    $logUtils->exportToHTML();
    exit;
  }

  function exportToXML() {
    $logUtils = & new LogUtils();
    $logUtils->exportToXML();
    exit;
  }

  function defaultTask() {
    $this->about();
  }


}