<?php
/** ****************************************************************
 * This file is part of SecurityImages for Joomla!.
 *
 * SecurityImages is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.

 * Foobar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package		SecurityImages
 * @copyright	Copyright (C) 2004 - 2008 Cdric Walter. All rights reserved.
 *******************************************************************/

defined( '_JEXEC' ) or die( 'Restricted access' );

class SecurityImagesCore extends JObject {

  #temporary variables use across all method
  var $red = "";
  var $green = "";
  var $blue = "";
  
  var $captchaSize = "B";

  var $functionCreateImage = 'imagecreatetruecolor';
  var $functionColorize = 'imagecolorallocate';

  var $fullPathToFont = null;

  /**
   * Enter description here...
   *
   * @return SecurityImagesCore
   */
  function SecurityImagesCore() {
    $this->fullPathToFont = JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_securityimages'.DS.'fonts'.DS;

    #verify TTF range
    /*
     $temp = array();
     foreach($TTF_RANGE as $k=>$v)
     {1 3
     if(is_readable($TTF_folder.$v)) $temp[] = $v;
     }
     $TTF_RANGE = $temp;
     */
    if ($this->getGDVersion() >= 2) {
      $this->functionCreateImage = 'imagecreatetruecolor';
      $this->functionColorize = 'imagecolorallocate';
    } else {
      $this->functionCreateImage = 'imageCreate';
      $this->functionColorize = 'imagecolorclosest';
    }
  }

  function setCaptchaSize($captchaSize) {
    $this->captchaSize = $captchaSize;
  }
  
  
  /**
   * Enter description here...
   *
   * @param unknown_type $min
   * @param unknown_type $max
   */
  function getRandomColor($min, $max) {
    srand((double) microtime() * 1000000);
    $this->red = intval(rand($min, $max));
    srand((double) microtime() * 1000000);
    $this->green = intval(rand($min, $max));
    srand((double) microtime() * 1000000);
    $this->blue = intval(rand($min, $max));
  }

  /**
   * Enter description here...
   *
   * @param unknown_type $twidth
   * @param unknown_type $theight
   * @param unknown_type $image
   */
  function createGrillAcrossImage($twidth, $theight, $image) {

    for ($i = 0; $i < $twidth; $i += $twidth / 2.5) {
      $this->getRandomColor(160, 224);
      $color = call_user_func($this->functionColorize, $image, $this->red, $this->green, $this->blue);
      @ imageline($image, $i, 0, $i, $theight, $color);
    }
    for ($i = 0; $i < $theight; $i += $theight / 2.8) {
      $this->getRandomColor(160, 224);
      $color = call_user_func($this->functionColorize, $image, $this->red, $this->green, $this->blue);
      @ imageline($image, 0, $i, $twidth, $i, $color);
    }
  }

  /**
   * Enter description here...
   *
   * @param unknown_type $image
   */
  function outputImage($image) {
    include (JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_securityimages'.DS.'pluginsA'.DS.'core'.DS.'1.1'.DS.'config.php');

    switch ($securityImagesoutput) {
      case "jpg" :
        header("Content-Type: image/jpeg");
        ImageJPEG($image);
        break;
      case "gif" :
        header("Content-Type: image/gif");
        ImageGIF($image);
        break;
      case "png" :
      default :
        header("Content-Type: image/png");
        ImagePNG($image);
        break;
    }
    imagedestroy($image);
  }

  /**
   * Enter description here...
   *
   * @return unknown
   */
  function generateRandomTextString() {
    include (JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_securityimages'.DS.'pluginsA'.DS.'core'.DS.'1.1'.DS.'config.php');

    $chars = array ("a", "A", "b", "B", "c", "C", "d", "D", "e", "E", "f", "F", "g", "G", "h", "H", "i", "I", "j", "J", "k", "K", "l", "L", "m", "M", "n", "N", "o", "O", "p", "P", "q", "Q", "r", "R", "s", "S", "t", "T", "u", "U", "v", "V", "w", "W", "x", "X", "y", "Y", "z", "Z", "1", "2", "3", "4", "5", "6", "7", "8", "9");

    if ($securityimages_textUseExtendedCharacterSet) {
      $chars = array ("a", "A", "b", "B", "c", "C", "d", "D", "e", "E", "f", "F", "g", "G", "h", "H", "i", "I", "j", "J", "k", "K", "l", "L", "m", "M", "n", "N", "o", "O", "p", "P", "q", "Q", "r", "R", "s", "S", "t", "T", "u", "U", "v", "V", "w", "W", "x", "X", "y", "Y", "z", "Z", "1", "2", "3", "4", "5", "6", "7", "8", "9", "+", "*", "%", "&", "/", "(", ")", "=", "?", "!", "$", "", "@", "#");
    }
    $textstr = "";
    $newtextlength = $textLength;
    if ($securityimages_userandomtextlength) {
      $newtextlength = rand($securityimages_randomtextlengthmin, $securityimages_randomtextlengthmax);
    }
    for ($i = 0; $i < $newtextlength; $i ++) {
      $textstr .= $chars[rand(0, count($chars) - 1)];
    }
    return $textstr;
  }

  /**
   * Enter description here...
   *
   * @return unknown
   */
  function getGDVersion() {
    if (function_exists('imagecreatetruecolor')) {
      return 2;
    }
    else {
      error_log('GD2 is needed for securityimages to work correctly');
      die('Need  GD PHP extension library'); // no GD installed, or old version
    }
  }

  /**
   * Enter description here...
   *
   * @return unknown
   */
  function getRandomTrueTypeFont() {
    include (JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_securityimages'.DS.'pluginsA'.DS.'core'.DS.'1.1'.DS.'config.php');

    srand((float) microtime() * 10000000);

    $item = array_rand(explode(',',$securityimages_fontsarray));
    $fontsArray = explode(',',$securityimages_fontsarray);

    return $this->fullPathToFont.$fontsArray[$item];
  }


  /**
   * Enter description here...
   *
   * @return unknown
   */
  function getTrueTypeFont() {
    include (JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_securityimages'.DS.'pluginsA'.DS.'core'.DS.'1.1'.DS.'config.php');
     
    $fontsArray = explode(',',$securityimages_fontsarray);

    return $this->fullPathToFont.$fontsArray[0];
  }

  /**
   * Enter description here...
   *
   * @return unknown
   */
  function loadRandomBackgroundImage() {
    include (JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_securityimages'.DS.'pluginsA'.DS.'core'.DS.'1.1'.DS.'config.php');
    $BASE = JPATH_SITE .DS.'media'.DS.'com_securityimages'.DS.'backgrounds'.DS;
    
    $_array = $this->captchaSize == "S" ? $selectedSmallBackground : $selectedBigBackground;
    $bkgArray = explode(",", $_array);

    //an array start at 0 and stop at n-1
    $index = rand(0, sizeof($bkgArray)-1);
    $imgname = $BASE.$bkgArray[$index];
    $image = @ imagecreatefrompng($imgname);
    /* Attempt to open */
    if (!$image) { /* See if it failed */
      $image = imagecreate(150, 30); /* Create a blank image */
      $bgc = imagecolorallocate($image, 255, 255, 255);
      $tc = imagecolorallocate($image, 0, 0, 0);
      imagefilledrectangle($image, 0, 0, 150, 30, $bgc);
      /* Output an errmsg */
      imagestring($image, 1, 5, 5, "Error loading $index", $tc);
    }
    return $image;
  }


  /**
   * Enter description here...
   *
   */
  function getCaptcha() {
    include (JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_securityimages'.DS.'pluginsA'.DS.'core'.DS.'1.1'.DS.'config.php');
    
    $image = $this->loadRandomBackgroundImage();
    $textstr = $this->generateRandomTextString();

    //Create random size, angle, and dark color
    $size = $textFontSizeDefualt;
    if ($useRandomSize = 1) {
      $size = rand($textFontSizeMin, $textFontSizeMax);
    }
    $angle = 0;
    if ($useRandomTextAngle) {
      $angle = rand($textAngleMin, $textAngleMax);
    }

    $this->getRandomColor($securityimages_textRgbMin, $securityimages_textRgbMax);
    $color = ImageColorAllocate($image, $this->red, $this->green, $this->blue);

    //Determine text size, and use dimensions to generate x & y coordinates
    $_fullPathToFont = $this->getTrueTypeFont();
    if ($useRandomFont) {
      $_fullPathToFont = $this->getRandomTrueTypeFont();
    }

    if ($alignementStrategy == "0") {
      $alignementStrategy = rand(1, 3);
    }

    //Add text to image
    switch ($alignementStrategy) {
      case "1" :
        $characterNumber = strlen($textstr);
        //start at 1/third of image width
        $x = imagesx($image) / 3;
        for ($i = 0; $i < $characterNumber; $i ++) {
          $systemFont = rand(4, 5);
          $x = $x +rand(imagefontwidth($systemFont), imagefontwidth($systemFont) * 2);
          $y = rand(1, imagesy($image) - imagefontheight($systemFont));
          imagestring($image, $systemFont, $x, $y, $textstr[$i], $color);
        }
        break;

      case "2" :
        $characterNumber = strlen($textstr);
        //hardcoded I need some fucntion on TTF which return size of fonts...
        $x = 5; //imagesx($image) / 3;
        $imagefontheight = 0.2;
        $imagefontwidth = 15;
        for ($i = 0; $i < $characterNumber; $i ++) {
          $x = $x +rand($imagefontwidth, $imagefontwidth * 2);
          $y = rand(15, 35); //rand(1, imagesy($image)  - $imagefontheight);
          ImageTTFText($image, $size, $angle, $x, $y, $color, $_fullPathToFont, $textstr[$i]);
        }
        break;

      default :
        $textsize = imagettfbbox($size, $angle, $_fullPathToFont, $textstr);
        $twidth = abs($textsize[2] - $textsize[0]);
        $theight = abs($textsize[5] - $textsize[3]);
        $x = (imagesx($image) / 2) - ($twidth / 2) + (rand(-20, 20));
        $y = (imagesy($image)) - ($theight / 2);
        ImageTTFText($image, $size, $angle, $x, $y, $color, $_fullPathToFont, $textstr);
        break;
    }

    if ($securityimages_usegrille) {
      $this->createGrillAcrossImage(230, 35, $image);
    }

     $session =& JFactory::getSession();
     $session->set('publicKey',$textstr);

     $this->outputImage($image);
      exit;
  }

}

?>