<?php

/** ****************************************************************
 * This file is part of SecurityImages for Joomla!.
 *
 * SecurityImages is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.

 * Foobar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package		SecurityImages
 * @copyright	Copyright (C) 2004 - 2008 Cdric Walter. All rights reserved.
 *******************************************************************/

defined( '_JEXEC' ) or die( 'Restricted access' );

class FileSelector extends JObject {

	var $selectedRessourceName = array (100);
	var $fileList = null;

	var $directorySource = null;
	var $webserverDirectory = null;
	var $regexFileName = null;
	var $fileSelectorNumberofColumns = 3;
	var $postVariable = null;
	var $previousSelection = null;
	var $title = "File Selector";

	/**
	 * @author Walter Cedric, www.waltercedric.com
	 */
	function FileSelector($directorySource, $webserverDirectory, $regexFileName, $fileSelectorNumberofColumns = 3, $previousSelection = null, $postVariable,
	$title) {
		$this->directorySource = $directorySource;
		$this->regexFileName = $regexFileName;
		$this->webserverDirectory = $webserverDirectory;
		$this->fileSelectorNumberofColumns = $fileSelectorNumberofColumns;
		$this->postVariable = $postVariable;
		$this->previousSelection = $previousSelection;
		$this->title = $title;
	}
	
	/**
	 * @author Walter Cedric, www.waltercedric.com
	 */
	function readUserSelection() {
		$cids = implode(',', $_POST ($this->postVariable));
		return $cids;
	}

	/**
	 * @author Walter Cedric, www.waltercedric.com
	 */
	function filterDirectory() {
		$handle = null;
		if ($handle = opendir($this->directorySource)) {
			$i = 0;
			while (false !== ($file = readdir($handle))) {
				//only add selected resource to array
				if  (ereg($this->regexFileName, "".$file))  
					$this->selectedRessourceName[$i ++] = $file;
			}
		}
		closedir($handle);
	}

	/**
	* @author Walter Cedric, www.waltercedric.com
	*/
	function displayHtmlForm() {
		$this->filterDirectory();
		
		$html = "<table>";
		$html .= "<th colspan='$this->fileSelectorNumberofColumns'>$this->title</th>";
		$columnCounter = 1;
		$html .= "<tr class='row$k'>";
		$k = 0;
		$checkboxName = $this->postVariable."[]";
		for ($index = 0; $index < sizeof($this->selectedRessourceName); $index ++) {
			$array_element = $this->selectedRessourceName[$index];
			$checked =  in_array($array_element , $this->previousSelection) ? "CHECKED" : ""; 
			
			$html .= "<td nowrap><input type='checkbox' id='cb$index' name='$checkboxName' value='$array_element' ".
						$checked.
						" >&nbsp;".$this->doPreview($array_element)."<td>";

			$columnCounter ++;
			if ($columnCounter > $this->fileSelectorNumberofColumns) {
				$columnCounter = 1;
				$html .= "</tr>";
				$html .= "<tr class='row$k'>";
			}
			$k = 1 - $k;
		}

		$html .= "</table>";
		return $html;
	}

	/**
	 * @author Walter Cedric, www.waltercedric.com
	 */
	function doPreview($array_element) {
		//TODO recognize file type and provide default icons
		return "<img src=".$this->webserverDirectory."/".$array_element." alt='$array_element' title='$array_element' align='middle'>";
	}

	//I wish phpeclipse could generate accessor
	function setSelectedRessourceName($selectedRessourceName) {
		$this->selectedRessourceName = $selectedRessourceName;
	}
	function getSelectedRessourceName() {
		return $this->selectedRessourceName;
	}
	
	/**
	 * @author Walter Cedric, www.waltercedric.com
	 */
	function setFileList($fileList) {
		$this->fileList = $fileList;
	}
	function getFileList() {
		return $this->fileList;
	}

	function setDirectorySource($directorySource) {
		$this->directorySource = $directorySource;
	}
	function getDirectorySource() {
		return $this->directorySource;
	}

	function setRegexFileName($regexFileName) {
		$this->regexFileName = $regexFileName;
	}
	function getRegexFileName() {
		return $this->regexFileName;
	}

	function setFileSelectorNumberofColumns($fileSelectorNumberofColumns) {
		$this->fileSelectorNumberofColumns = $fileSelectorNumberofColumns;
	}
	function getFileSelectorNumberofColumns() {
		return $this->fileSelectorNumberofColumns;
	}

}
?>