<?php
/*
 *
 * Name: WaterCap CAPTCHA Image Generator
 * Author: Pavel Simakov
 * Copyright: 2007 Pavel Simakov
 * Version: 0.9
 * Requirements: PHP 4/5 with GD and FreeType libraries
 * Link: http://www.softwaresecretweapons.com/jspwiki/Wiki.jsp?page=WaterCap_Strong_PHP_CAPTCHA_With_Negative_Spaces_And_Shadows
 *
 * Based on prior work of: Simon Jarvis
 * Link: http://www.white-hat-web-design.co.uk/articles/php-captcha.php
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details:
 * http://www.gnu.org/licenses/gpl.html
 *
 */
defined( '_JEXEC' ) or die( 'Restricted access' );


class securityimagesWaterCap extends JObject {

		var $functionCreateImage;
		var $functionColorize;

		var $public_K;
		/** @private **/
		var $private_K;
		/** @private **/
		var $key; // md5-key

		var $code;

		var $absolutePath;


		function securityimagesWaterCap() {
				$arrStr = explode(DIRECTORY_SEPARATOR, __FILE__ );
				$this->absolutePath = array_slice($arrStr, 0,  count($arrStr) -6);
				$this->absolutePath = implode (DIRECTORY_SEPARATOR, $this->absolutePath);
					
					
				global $secretstring;
				if ($this->getGDVersion() >= 2) {
						$this->functionCreateImage = 'imagecreatetruecolor';
						$this->functionColorize = 'imagecolorallocate';
				} else {
						$this->functionCreateImage = 'imageCreate';
						$this->functionColorize = 'imagecolorclosest';
				}
				$this->code = $this->generateRandomTextString();
				$this->public_K = $this->code;
				$this->key = md5($secretstring);
				$this->private_K = $this->generate_private($this->public_K, $this->key);
		}

		function getPublicKey()
		{
				return $this->public_K;
		}
		function getPrivateKey()
		{
				return $this->private_K;
		}
		function getKey()
		{
				return $this->key;
		}

		function getGDVersion() {
				if (function_exists('imagecreatetruecolor'))
				return 2;
				else
				die('Need  GD PHP extension library'); // no GD installed, or old version
		}

			
		function getRandomTrueTypeFont() {
				include ($this->absolutePath."/administrator/components/com_securityimages/pluginsA/watercap/1.0/config.php");
				$fullPathToFont = $this->absolutePath."/administrator/components/com_securityimages/fonts/";	
				
				srand((float) microtime() * 10000000);
				$item = array_rand(explode(',',$securityimages_fontsarray));
				$fontsArray = explode(',',$securityimages_fontsarray);

				return $fullPathToFont.$fontsArray[$item];
		}

		function generateRandomTextString() {
				require ($this->absolutePath."/administrator/components/com_securityimages/pluginsA/watercap/1.0/config.php");
				
				$chars = array ("a", "A", "b", "B", "c", "C", "d", "D", "e", "E", "f", "F", "g", "G", "h", "H", "i", "I", "j", "J", "k", "K", "l", "L", "m", "M", "n", "N", "o", "O", "p", "P", "q", "Q", "r", "R", "s", "S", "t", "T", "u", "U", "v", "V", "w", "W", "x", "X", "y", "Y", "z", "Z", "1", "2", "3", "4", "5", "6", "7", "8", "9");

				if ($securityimages_textUseExtendedCharacterSet)
				$chars = array ("a", "A", "b", "B", "c", "C", "d", "D", "e", "E", "f", "F", "g", "G", "h", "H", "i", "I", "j", "J", "k", "K", "l", "L", "m", "M", "n", "N", "o", "O", "p", "P", "q", "Q", "r", "R", "s", "S", "t", "T", "u", "U", "v", "V", "w", "W", "x", "X", "y", "Y", "z", "Z", "1", "2", "3", "4", "5", "6", "7", "8", "9", "+", "*", "%", "&", "/", "(", ")", "=", "?", "!", "$", "", "@", "#");

				$textstr = "";
				$newtextlength = $textLength;
				if ($securityimages_userandomtextlength)
				$newtextlength = rand($securityimages_randomtextlengthmin, $securityimages_randomtextlengthmax);

				for ($i = 0; $i < $newtextlength; $i ++) {
						$textstr .= $chars[rand(0, count($chars) - 1)];
				}
				return $textstr;
		}

		function outputImage($image) {
				require ($this->absolutePath."/administrator/components/com_securityimages/pluginsA/watercap/1.0/config.php");

				switch ($securityImagesoutput) {
						case "jpg" :
								header("Content-Type: image/jpeg");
								ImageJPEG($image);
								break;
						case "gif" :
								header("Content-Type: image/gif");
								ImageGIF($image);
								break;
						case "png" :
						default :
								header("Content-Type: image/png");
								ImagePNG($image);
								break;
				}
				imagedestroy($image);
		}

		function waterCap ($font, $width='250', $height='60') {
				require ($this->absolutePath."/administrator/components/com_securityimages/pluginsA/watercap/1.0/config.php");
					
				if ($font == null) {
						$font = $this->getRandomTrueTypeFont();
				}

				/* seed random number gen to produce the same noise pattern time after time */
				mt_srand(crc32($code));

				/* init image */
				$font_size = $height * 0.85;
				$image = @imagecreate($width, $height) or die('Cannot initialize new GD image stream');

				/* set the colours */
				$background_color = call_user_func($this->functionColorize,$image, 255, 255, 255);
				$text_color = call_user_func($this->functionColorize,$image, 20, 40, 100);
				$noise_color = call_user_func($this->functionColorize,$image, 100, 120, 180);

				/* create textbox and add text */
				$textbox = imagettfbbox($font_size, 0, $font, $this->code) or die('Error in imagettfbbox function');
				$x = ($width - $textbox[4])/2;
				$y = ($height - $textbox[5])/2;
				$d = -1;
				imagettftext($image, $font_size, 0, $x, $y, $text_color, $font , $this->code) or die('Error in imagettftext function');
				imagettftext(
				$image, $font_size, 0, $x + $d, $y + $d, $noise_color, $font , $this->code
				) or die('Error in imagettftext function');
				imagettftext(
				$image, $font_size, 0, $x + 2 * $d + 1, $y + 2 * $d + 1, $noise_color, $font , $this->code
				) or die('Error in imagettftext function');
				imagettftext(
				$image, $font_size, 0, $x + 2 * $d, $y + 2 * $d, $background_color, $font , $this->code
				) or die('Error in imagettftext function');

				/* mix in background dots */
				for( $i=0; $i<($width*$height)/10; $i++ ) {
						imagefilledellipse($image, mt_rand(0,$width), mt_rand(0,$height), 1, 1, $background_color);
				}

				/* mix in text and noise dots */
				for( $i=0; $i<($width*$height)/25; $i++ ) {
						imagefilledellipse($image, mt_rand(0,$width), mt_rand(0,$height), 1, 1, $noise_color);
						imagefilledellipse($image, mt_rand(0,$width), mt_rand(0,$height), 1, 1, $text_color);
				}

				/* rotate a bit to add fuzziness */
				$image = imagerotate($image, 1, $background_color);

				/* output */
				if ($watermarkAntiFreePornAttack) {  }
	  	$this->addAntiPorn($image, $width, $height);
	  	//}

	  	$this->outputImage($image);
	  	exit;
		}
			
		function generate_private($public, $hnkey)
		{
				require ($this->absolutePath."/administrator/components/com_securityimages/pluginsA/watercap/1.0/config.php");

				$key = substr(md5($hnkey . $public), 16 - $chars / 2, $chars);
				return $key;
		}
			
			
			
		function addAntiPorn($image,$width, $height) {
				require ($this->absolutePath."/administrator/components/com_securityimages/pluginsA/watercap/1.0/config.php");
				//$site_tags = array ($site_tags0, $site_tags1);
				$freePornAttackTextColor = ImageColorAllocate($image, 0, 0, 0);
				if (is_array($site_tags)) {
						for ($i = 0; $i < sizeof($site_tags); $i ++) {
								// ensure tags are centered
								$tag_width = strlen($site_tags[$i]) * 6;
								// write tag is chosen position
								if ($tag_pos == 0 || $tag_pos == 2) {
										// write at top
										ImageString($image, 2, intval($width / 2) - intval($tag_width / 2), (10 * $i), $site_tags[$i], $freePornAttackTextColor);
								}
								if ($tag_pos == 1 || $tag_pos == 2) {
										// write at bottom
										ImageString($image, 2, intval($width / 2) - intval($tag_width / 2), ($height -34 + ($i * 10)), $site_tags[$i], $freePornAttackTextColor);
								}
						}
				}

		}
			
}
?>