/*
 * FancyBox - simple jQuery plugin for fancy image zooming
 * Examples and documentation at: http://fancy.klade.lv/
 * Version: 1.0.0 (29/04/2008)
 * Copyright (c) 2008 Janis Skarnelis
 * Licensed under the MIT License: http://www.opensource.org/licenses/mit-license.php
 * Requires: jQuery v1.2.1 or later
*/
(function($) {
	var opts = {},
		imgPreloader = new Image, imgTypes = ['png', 'jpg', 'jpeg', 'gif'],
		loadingTimer, loadingFrame = 1;

   $j.fn.fancybox = function(settings) {
		opts.settings = $j.extend({}, $j.fn.fancybox.defaults, settings);

		$j.fn.fancybox.init();

		return this.each(function() {
			var $this = $j(this);
			var o = $j.metadata ? $j.extend({}, opts.settings, $this.metadata()) : opts.settings;

			$this.unbind('click').click(function() {
				if ( settings.parse ) {
					rel = this[settings.parse];
					var rel_settings = $j.fn.fancybox.parseRel( rel );
					o = $j.extend({}, o, rel_settings );
				}
				$j.fn.fancybox.start(this, o); return false;
			});
		});
	};

	$j.fn.fancybox.start = function(el, o) {
		if (opts.animating) return false;

		if (o.overlayShow) {
			$j("#fancy_wrap").prepend('<div id="fancy_overlay"></div>');
			$j("#fancy_overlay").css({'width': $j(window).width(), 'height': $j(document).height(), 'opacity': o.overlayOpacity});

			if ($j.browser.msie) {
				$j("#fancy_wrap").prepend('<iframe id="fancy_bigIframe" scrolling="no" frameborder="0"></iframe>');
				$j("#fancy_bigIframe").css({'width': $j(window).width(), 'height': $j(document).height(), 'opacity': 0});
			}

			if (o.closeWithOverlay) {
				$j("#fancy_overlay").click($j.fn.fancybox.close);
			}
		}

		opts.itemArray	= [];
		opts.itemNum	= 0;

		if (jQuery.isFunction(o.itemLoadCallback)) {
		   o.itemLoadCallback.apply(this, [opts]);

			var c	= $j(el).children("img:first").length ? $j(el).children("img:first") : $j(el);
			var tmp	= {'width': c.width(), 'height': c.height(), 'pos': $j.fn.fancybox.getPosition(c)};

		   for (var i = 0; i < opts.itemArray.length; i++) {
				opts.itemArray[i].o = $j.extend({}, o, opts.itemArray[i].o);

				if (o.zoomSpeedIn > 0 || o.zoomSpeedOut > 0) {
					opts.itemArray[i].orig = tmp;
				}
		   }

		} else {
			if (!el.rel || el.rel == '') {
				var item = {url: el.href, title: el.title, o: o};

				if (o.zoomSpeedIn > 0 || o.zoomSpeedOut > 0) {
					var c = $j(el).children("img:first").length ? $j(el).children("img:first") : $j(el);
					item.orig = {'width': c.width(), 'height': c.height(), 'pos': $j.fn.fancybox.getPosition(c)};
				}

				opts.itemArray.push(item);

			} else {
				var arr	= $j("a[@rel=" + el.rel + "]").get();

				for (var i = 0; i < arr.length; i++) {
					var tmp		= $j.metadata ? $j.extend({}, o, $j(arr[i]).metadata()) : o;
   					var item	= {url: arr[i].href, title: arr[i].title, o: tmp};

   					if (o.zoomSpeedIn > 0 || o.zoomSpeedOut > 0) {
						var c = $j(arr[i]).children("img:first").length ? $j(arr[i]).children("img:first") : $j(el);

						item.orig = {'width': c.width(), 'height': c.height(), 'pos': $j.fn.fancybox.getPosition(c)};
					}

					if (arr[i].href == el.href) opts.itemNum = i;

					opts.itemArray.push(item);
				}
			}
		}

		$j.fn.fancybox.changeItem(opts.itemNum);
	};

	$j.fn.fancybox.changeItem = function(n) {
		$j.fn.fancybox.showLoading();

		opts.itemNum = n;

		$j("#fancy_nav").empty();
		$j("#fancy_outer").stop();
		$j("#fancy_title").hide();
		$j(document).unbind("keydown");

		imgRegExp = imgTypes.join('|');
    	imgRegExp = new RegExp('\.' + imgRegExp + '$', 'i');

		var url = opts.itemArray[n].url;

		if (url.match(/#/)) {
			var target = window.location.href.split('#')[0]; target = url.replace(target,'');

	        $j.fn.fancybox.showItem('<div id="fancy_div">' + $j(target).html() + '</div>');

	        $j("#fancy_loading").hide();

		} else if (url.match(imgRegExp)) {
			$j(imgPreloader).unbind('load').bind('load', function() {
				$j("#fancy_loading").hide();

				opts.itemArray[n].o.frameWidth	= imgPreloader.width;
				opts.itemArray[n].o.frameHeight	= imgPreloader.height;

				$j.fn.fancybox.showItem('<img id="fancy_img" src="' + imgPreloader.src + '" />');

			}).attr('src', url + '?rand=' + Math.floor(Math.random() * 999999999) );

		} else {
			$j.fn.fancybox.showItem('<iframe id="fancy_frame" onload="$j.fn.fancybox.showIframe()" name="fancy_iframe' + Math.round(Math.random()*1000) + '" frameborder="0" hspace="0" src="' + url + '"></iframe>');
		}
	};

	$j.fn.fancybox.showIframe = function() {
		$j("#fancy_loading").hide();
		$j("#fancy_frame").show();
	};

	$j.fn.fancybox.showItem = function(val) {
		$j.fn.fancybox.preloadNeighborImages();

		var viewportPos	= $j.fn.fancybox.getViewport();
		var itemSize	= $j.fn.fancybox.getMaxSize(viewportPos[0] - 50, viewportPos[1] - 100, opts.itemArray[opts.itemNum].o.frameWidth, opts.itemArray[opts.itemNum].o.frameHeight);

		var itemLeft	= viewportPos[2] + Math.round((viewportPos[0] - itemSize[0]) / 2) - 20;
		var itemTop		= viewportPos[3] + Math.round((viewportPos[1] - itemSize[1]) / 2) - 40;

		var itemOpts = {
			'left':		itemLeft,
			'top':		itemTop,
			'width':	itemSize[0] + 'px',
			'height':	itemSize[1] + 'px'
		};

		if (opts.active) {
			$j('#fancy_content').fadeOut("normal", function() {
				$j("#fancy_content").empty();

				$j("#fancy_outer").animate(itemOpts, "normal", function() {
					$j("#fancy_content").append($j(val)).fadeIn("normal");
					$j.fn.fancybox.updateDetails();
				});
			});

		} else {
			opts.active = true;

			$j("#fancy_content").empty();

			if ($j("#fancy_content").is(":animated")) {
				console.info('animated!');
			}

			if (opts.itemArray[opts.itemNum].o.zoomSpeedIn > 0) {
				opts.animating		= true;
				itemOpts.opacity	= "show";

				$j("#fancy_outer").css({
					'top':		opts.itemArray[opts.itemNum].orig.pos.top - 18,
					'left':		opts.itemArray[opts.itemNum].orig.pos.left - 18,
					'height':	opts.itemArray[opts.itemNum].orig.height,
					'width':	opts.itemArray[opts.itemNum].orig.width
				});

				$j("#fancy_content").append($j(val)).show();

				$j("#fancy_outer").animate(itemOpts, opts.itemArray[opts.itemNum].o.zoomSpeedIn, function() {
					opts.animating = false;
					$j.fn.fancybox.updateDetails();
				});

			} else {
				$j("#fancy_content").append($j(val)).show();
				$j("#fancy_outer").css(itemOpts).show();
				$j.fn.fancybox.updateDetails();
			}
		 }
	};

	$j.fn.fancybox.updateDetails = function() {
		$j("#fancy_bg,#fancy_close").show();

		if (opts.itemArray[opts.itemNum].title !== undefined && opts.itemArray[opts.itemNum].title !== '') {
			$j('#fancy_title div').html(opts.itemArray[opts.itemNum].title);
			$j('#fancy_title').show();
		}

		if (opts.itemArray[opts.itemNum].o.hideOnContentClick) {
			$j("#fancy_content").click($j.fn.fancybox.close);
		} else {
			$j("#fancy_content").unbind('click');
		}

		if (opts.itemNum != 0) {
			$j("#fancy_nav").append('<a id="fancy_left" href="javascript:;"></a>');

			$j('#fancy_left').click(function() {
				$j.fn.fancybox.changeItem(opts.itemNum - 1); return false;
			});
		}

		if (opts.itemNum != (opts.itemArray.length - 1)) {
			$j("#fancy_nav").append('<a id="fancy_right" href="javascript:;"></a>');

			$j('#fancy_right').click(function(){
				$j.fn.fancybox.changeItem(opts.itemNum + 1); return false;
			});
		}

		$j(document).keydown(function(event) {
			if (event.keyCode == 27) {
            	$j.fn.fancybox.close();

			} else if(event.keyCode == 37 && opts.itemNum != 0) {
            	$j.fn.fancybox.changeItem(opts.itemNum - 1);

			} else if(event.keyCode == 39 && opts.itemNum != (opts.itemArray.length - 1)) {
            	$j.fn.fancybox.changeItem(opts.itemNum + 1);
			}
		});
	};

	$j.fn.fancybox.preloadNeighborImages = function() {
		if ((opts.itemArray.length - 1) > opts.itemNum) {
			preloadNextImage = new Image();
			preloadNextImage.src = opts.itemArray[opts.itemNum + 1].url;
		}

		if (opts.itemNum > 0) {
			preloadPrevImage = new Image();
			preloadPrevImage.src = opts.itemArray[opts.itemNum - 1].url;
		}
	};

	$j.fn.fancybox.close = function() {
		if (opts.animating) return false;

		$j(imgPreloader).unbind('load');
		$j(document).unbind("keydown");

		$j("#fancy_loading,#fancy_title,#fancy_close,#fancy_bg").hide();

		$j("#fancy_nav").empty();

		opts.active	= false;

		if (opts.itemArray[opts.itemNum].o.zoomSpeedOut > 0) {
			var itemOpts = {
				'top':		opts.itemArray[opts.itemNum].orig.pos.top - 18,
				'left':		opts.itemArray[opts.itemNum].orig.pos.left - 18,
				'height':	opts.itemArray[opts.itemNum].orig.height,
				'width':	opts.itemArray[opts.itemNum].orig.width,
				'opacity':	'hide'
			};

			opts.animating = true;

			$j("#fancy_outer").animate(itemOpts, opts.itemArray[opts.itemNum].o.zoomSpeedOut, function() {
				$j("#fancy_content").hide().empty();
				$j("#fancy_overlay,#fancy_bigIframe").remove();
				opts.animating = false;
			});

		} else {
			$j("#fancy_outer").hide();
			$j("#fancy_content").hide().empty();
			$j("#fancy_overlay,#fancy_bigIframe").fadeOut("fast").remove();
		}
	};

	$j.fn.fancybox.showLoading = function() {
		clearInterval(loadingTimer);

		var pos = $j.fn.fancybox.getViewport();

		$j("#fancy_loading").css({'left': ((pos[0] - 40) / 2 + pos[2]), 'top': ((pos[1] - 40) / 2 + pos[3])}).show();
		$j("#fancy_loading").bind('click', $j.fn.fancybox.close);

		loadingTimer = setInterval($j.fn.fancybox.animateLoading, 66);
	};

	$j.fn.fancybox.animateLoading = function(el, o) {
		if (!$j("#fancy_loading").is(':visible')){
			clearInterval(loadingTimer);
			return;
		}

		$j("#fancy_loading > div").css('top', (loadingFrame * -40) + 'px');

		loadingFrame = (loadingFrame + 1) % 12;
	};

	$j.fn.fancybox.init = function() {
		if (!$j('#fancy_wrap').length) {
			$j('<div id="fancy_wrap"><div id="fancy_loading"><div></div></div><div id="fancy_outer"><div id="fancy_inner"><div id="fancy_nav"></div><div id="fancy_close"></div><div id="fancy_content"></div><div id="fancy_title"></div></div></div></div>').appendTo("body");
			$j('<div id="fancy_bg"><div class="fancy_bg fancy_bg_n"></div><div class="fancy_bg fancy_bg_ne"></div><div class="fancy_bg fancy_bg_e"></div><div class="fancy_bg fancy_bg_se"></div><div class="fancy_bg fancy_bg_s"></div><div class="fancy_bg fancy_bg_sw"></div><div class="fancy_bg fancy_bg_w"></div><div class="fancy_bg fancy_bg_nw"></div></div>').prependTo("#fancy_inner");

			$j('<table cellspacing="0" cellpadding="0" border="0"><tr><td id="fancy_title_left"></td><td id="fancy_title_main"><div></div></td><td id="fancy_title_right"></td></tr></table>').appendTo('#fancy_title');
		}

		if ($j.browser.msie) {
			$j("#fancy_inner").prepend('<iframe id="fancy_freeIframe" scrolling="no" frameborder="0"></iframe>');
		}

		if (jQuery.fn.pngFix) $j(document).pngFix();

    	$j("#fancy_close").click($j.fn.fancybox.close);
	};

	$j.fn.fancybox.getPosition = function(el) {
		var pos = el.offset();

		pos.top	+= $j.fn.fancybox.num(el, 'paddingTop');
		pos.top	+= $j.fn.fancybox.num(el, 'borderTopWidth');

 		pos.left += $j.fn.fancybox.num(el, 'paddingLeft');
		pos.left += $j.fn.fancybox.num(el, 'borderLeftWidth');

		return pos;
	};

	$j.fn.fancybox.num = function (el, prop) {
		return parseInt($j.curCSS(el.jquery?el[0]:el,prop,true))||0;
	};

	$j.fn.fancybox.getPageScroll = function() {
		var xScroll, yScroll;

		if (self.pageYOffset) {
			yScroll = self.pageYOffset;
			xScroll = self.pageXOffset;
		} else if (document.documentElement && document.documentElement.scrollTop) {
			yScroll = document.documentElement.scrollTop;
			xScroll = document.documentElement.scrollLeft;
		} else if (document.body) {
			yScroll = document.body.scrollTop;
			xScroll = document.body.scrollLeft;
		}

		return [xScroll, yScroll];
	};

	$j.fn.fancybox.getViewport = function() {
		var scroll = $j.fn.fancybox.getPageScroll();

		return [$j(window).width(), $j(window).height(), scroll[0], scroll[1]];
	};

	$j.fn.fancybox.getMaxSize = function(maxWidth, maxHeight, imageWidth, imageHeight) {
		var r = Math.min(Math.min(maxWidth, imageWidth) / imageWidth, Math.min(maxHeight, imageHeight) / imageHeight);

		return [Math.round(r * imageWidth), Math.round(r * imageHeight)];
	};

	$j.fn.fancybox.defaults = {
		hideOnContentClick:	false,
		zoomSpeedIn:		500,
		zoomSpeedOut:		500,
		frameWidth:			600,
		frameHeight:		400,
		overlayShow:		true,
		closeWithOverlay:	true,
		overlayOpacity:		0.7,
		itemLoadCallback:	null,
		parse: false // 'rel'
	};

	$j.fn.fancybox.parseRel = function( query ) {
		var params = {};
		if ( !query ) {return params;} // return empty object
		var query = query.replace('{','').replace('}','');
		var pairs = query.split(';');
		for ( var i = 0; i < pairs.length; i++ ) {
			var keyval = pairs[i].split(':');
			if ( ! keyval || keyval.length != 2 ) {continue;}
			var key = unescape( keyval[0] );
			var val = unescape( keyval[1] );
			val = val.replace(/\+/g, ' ');
			if( !isNaN(val) ) val = parseFloat(val);
			if ( val == 'false' ) val = false;
			if ( val == 'true' ) val = true;
			params[key] = val;
		}
		return params;
	};
})(jQuery);

window.addEvent('domready', function() {
	$j("a.nn_fancybox").fancybox({parse: 'rel'});
});