<?php
/** ****************************************************************
 * This file is part of SecurityImages for Joomla!.
 *
 * SecurityImages is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.

 * Foobar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package		SecurityImages
 * @copyright	Copyright (C) 2004 - 2008 Cdric Walter. All rights reserved.
 *******************************************************************/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die();

class plgSystemSecurityImages extends JPlugin
{

  /**
   * Constructor
   *
   * For php4 compatability we must not use the __constructor as a constructor for plugins
   * because func_get_args ( void ) returns a copy of all passed arguments NOT references.
   * This causes problems with cross-referencing necessary for the observer design pattern.
   *
   * @access	protected
   * @param	object	$subject The object to observe
   * @param 	array   $config  An array that holds the plugin configuration
   * @since	1.0
   */
  /**
   function plgSystemSecurityImages()
   {
   // load plugin params info
   $plugin =& JPluginHelper::getPlugin('system', 'securityimages');
   $pluginParams = new JParameter( $plugin->params );

   $this->reloadCaptchaCount = $pluginParams->def( 'reloadCaptchaCount', 10 );
   }
   */

  /**
   * let caller decide which plugin he want to use
   */
  function onSecurityImagesDisplayByPlugin() {

    $plugin = JRequest::getCmd('plugin', 'hncaptcha');
    $version = JRequest::getCmd('version', '1.0');

    //if file exist then caller get what he asks
    if (file_exists(JPATH_SITE.DS.'components'.DS.'com_securityimages'.DS.'plugins'.DS.$plugin.DS.$version.DS.'imageGenerator.php')) {
      require_once (JPATH_SITE.DS.'components'.DS.'com_securityimages'.DS.'plugins'.DS.$plugin.DS.$version.DS.'imageGenerator.php');
      exit();
    }

    //otherwise use default plugin
    $this->onSecurityImagesDisplay();
  }
  
  /**
   * Main entry point on triger, admin choose the plugin name
   *
   */
  function onSecurityImagesDisplay() {
    if ($this->hasTooMuchReload()) { 
      exit();
    }
    
    include(JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_securityimages'.DS.'config.securityimages.php');
    require_once(JPATH_SITE.DS.'components'.DS.'com_securityimages'.DS.'plugins'.DS.$securityImagesPlugins.DS.$securityImagesPluginsVersion.DS.'imageGenerator.php');
    exit();
  }
  
  function onSecurityImagesRecaptchaDisplay() {
    if ($this->hasTooMuchReload()) { 
      exit();
    }
    
    require_once(JPATH_SITE.DS.'components'.DS.'com_securityimages'.DS.'plugins'.DS."recaptcha".DS."1.0".DS.'imageGenerator.php');
    exit();
  }
  

  /**
   * Enter description here...
   *
   * @param unknown_type $userTry
   * @param unknown_type $checkSecurity
   */
  function onSecurityImagesCheck($userTry, &$checkSecurity) {
    require_once (JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_securityimages'.DS.'class'.DS.'SecurityImagesHelper.php');

    $session =& JFactory::getSession();
    $reload = $session->get('reload');
    
    $plugin = &JPluginHelper::getPlugin('system', 'securityimages');
    $pluginParams = new JParameter( $plugin->params );
    if ($reload > $pluginParams->def( 'reloadCaptchaCount', 10 )) {
      return false;
    }
    
    $SecurityImagesHelper = &new SecurityImagesHelper();
    $checkSecurity = $SecurityImagesHelper->checkSecurityImageUserTry($userTry);
    return $checkSecurity;
  }

  /**
   * Enter description here...
   *
   * @param unknown_type $word
   * @param unknown_type $return
   */
  function onSecurityImagesCheckByPlugin($plugin,$version, $userTry, &$checkSecurity) {

    require_once (JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_securityimages'.DS.'class'.DS.'SecurityImagesHelper.php');

    $session =& JFactory::getSession();
    $reload = $session->get('reload');
    $plugin = &JPluginHelper::getPlugin('system', 'securityimages');
    $pluginParams = new JParameter( $plugin->params );
    if ($reload > $pluginParams->def( 'reloadCaptchaCount', 10 )) {
      return false;
    }

    $SecurityImagesHelper = &new SecurityImagesHelper();
    $checkSecurity = $SecurityImagesHelper->checkSecurityImageUserTry($userTry, $plugin,$version);
    return $checkSecurity;
  }

  function increaseReloadCounter() {
    $session =& JFactory::getSession();
    $reload = 0;
    $reload = $session->get('reload');
    $session->set('reload', ++$reload);
  }
  
  
  /**
   * check if user has made too much reload, if yes send him a blank image with a warning inside
   *
   */
  function hasTooMuchReload() {
    $this->increaseReloadCounter();
    
    $session =& JFactory::getSession();
    $reload = $session->get('reload');
    
    $plugin =&JPluginHelper::getPlugin('system', 'securityimages');
    $pluginParams = new JParameter( $plugin->params );
    
    if ($reload >  $pluginParams->def( 'reloadCaptchaCount', 10 )) {

      $image = imagecreate(150, 30);
      $bgc = imagecolorallocate($image, 0, 0, 0);
      $tc = imagecolorallocate($image, 255, 255, 255);
      imagefilledrectangle($image, 0, 0, 150, 30, $bgc);
       
      imagestring($image, 3, 5, 5, JText::_('Reload Limit Exceeded'), $tc);
      header("Content-Type: image/jpeg");

      if (function_exists('ImagePNG')) {ImagePNG($image);} else
      if (function_exists('ImageJPEG')) {ImageJPEG($image);} else
      if (function_exists('ImageGIF')) {ImageGIF($image);}
       
      imagedestroy($image);
      return true;
    }
    
    return false;
  }



}