<?php
/**
 * Joomla! Upgrade Helper
 * Step 1 - Download XML update file and display download options
 */
/** ensure this file is being included by a parent file */
defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

$v = new JVersion();
$version = $v->getShortVersion();

$url = "http://aide.joomla.fr/maj/update.xml";

$config =& JFactory::getConfig();
$tmp_path = $config->getValue('config.tmp_path');

$params =& JComponentHelper::getParams('com_jupdateman');




$target = $tmp_path . DS . 'jupgrader.xml';

$cached_update = $params->get('cached_update', 0);

if($cached_update) {
	if(!file_exists($target)) {
		HTML_jupgrader::showError( 'Fichier de mise à jour manquant. SVP <a href="'. $url .'" target="_blank">Télécharger la liste des mise à jour</a> "jupgrader.xml" et déposez le dans votre répertoire temporaire.<br />Le répertoire de destination: '. $target);
		return false;
	}
} else {
	$result = downloadFile($url,$target);
	if(is_object( $result )) {
		HTML_jupgrader::showError( 'Echec du téléchargement: '. $result->message . '('. $result->number . ')' );
		return false;
	}
}

if(!file_exists($target)) {
	HTML_jupgrader::showError( 'Le fichier de mise à jour est inexistant: '. $target );
}

// Yay! file downloaded! Processing time :(
$xmlDoc = new JSimpleXML();

if (!$xmlDoc->loadFile( $target )) {
	HTML_jupgrader::showError( 'L\'analyse du document XML a échoué!' );
	return false;
}

//$root = &$xmlDoc->documentElement;
$root = &$xmlDoc->document;

if ($root->name() != 'update') {
	HTML_jupgrader::showError( 'L\'analyse du document XML a échoué: pas de définition de mise à jour du fichier' );
	return false;
}
$rootattributes = $root->attributes();
$latest = $rootattributes['release'];
if($latest == $version) {
	echo "<p>Aucune mise à jour a été trouvé. <a href='index.php?option=com_jupdateman&task=step2&target=full'>Forcer la mise à jour &gt;&gt;&gt;</a></p><br /><br /><p>Merci de retenter la mise à jour ultérieurement ou de visiter le site <a href='http://www.joomla.fr' target='_blank'>www.joomla.fr</a></p>";
	echo '</div>';
	return true;
} elseif(version_compare($latest, $version, '<')) {
	echo "<p>Vous exécutez une version plus récente de Joomla! de celle qui est disponible pour le téléchargement.</p><br /><br />";
	echo "<p>Merci de vérifier <a href='http://www.joomla.fr' target='_blank'>www.joomla.fr</a> pour plus de détails sur les versions.</p>";
	echo '</div>';
	return true;
}

$updater = $root->getElementByPath('updater', 1);
if(!$updater) {
	HTML_jupgrader::showError( 'Impossible d\'obtenir des éléments de mise à jour. Mise à jour non valide!');
	return false;
}

$updater_attributes = $updater->attributes();

$session =& JFactory::getSession();
$session->set('jupdateman_updateurl', $updater->data());

if(version_compare($updater_attributes['minimumversion'], getComponentVersion(), '>')) 
{
	echo '<p>Vous version installée est inférieure à la version minimum requise pour cette mise à jour.</p>';
	echo '<p>SVP Mettez à jour cette extension. Cela peut être tenté automatiquement ou vous pouvez décider de télécharger la mise à jour et installer vous-même</p>';
	echo '<ul>';
	echo '<li><a href="index.php?option=com_jupdateman&task=autoupdate">Actualisation automatique</a></li>';
	echo '<li><a target="_blank" href="'. $updater->data() .'">Télécharger et installer manuellement le package (nouvelle fenêtre) </a></li>';
	echo '</ul>';
	return false;
}

if(version_compare($updater_attributes['currentversion'], getComponentVersion(), '>')) 
{
	echo '<p>An update ('. $updater_attributes['currentversion'] .') est disponible pour cette extension. Vous pouvez <a href="index.php?option=com_jupdateman&task=autoupdate">mettre à jour automatiquement</a> ou <a target="_blank" href="'. $updater->data() .'">télécharger manuellement</a> et installer la mise à jour.</p>';
}

echo "<p>Votre version de Joomla installé $version. La dernière version est  $latest. SVP selectionnez un pack de téléchargement:</p>";
$fulldownload = '';
$patchdownload = '';

// Get the full package
$fullpackage  				= $root->getElementByPath( 'fullpackage', 1 );
$fullpackageattr 			= $fullpackage->attributes();
$fulldetails 				= new stdClass();
$fulldetails->url 			= $fullpackageattr['url'];
$fulldetails->filename 		= $fullpackageattr['filename'];
$fulldetails->filesize 		= $fullpackageattr['filesize'];
$fulldetails->md5			= $fullpackageattr['md5'];

// Find the patch package
$patches_root = $root->getElementByPath( 'patches', 1 );
if (!is_null( $patches_root ) ) {
	// Patches :D
	$patches = $patches_root->children();
	if(count($patches)) {
		// Many patches! :D
		foreach($patches as $patch) {
			$patchattr = $patch->attributes();
			if ($patchattr['version'] == $version) {
				$patchdetails->url = $patchattr['url'];
				$patchdetails->filename = $patchattr['filename'];
				$patchdetails->filesize = $patchattr['filesize'];
				$patchdetails->md5		= $patchattr['md5'];
				break;
			}
		}

	}
}

$message_element = $root->getElementByPath('message');
if($message_element) {
	$message = $message_element->data();
	if(strlen($message)) {
		echo '<p style="background: lightblue; padding: 5px; spacing: 5px; border: 1px solid black;"><b>Message de mise à jour:</b><br /> '. $message.'</p>';
	}
}
$session->set('jupdateman_fullpackage', $fulldetails);
$session->set('jupdateman_patchpackage', $patchdetails);
?>
<ul>
	<li><a
		href="index.php?option=com_jupdateman&task=step2&target=full">Le package complet</a> (<?php echo round($fulldetails->filesize/1024/1024,2) ?>MB)<?php
	if($cached_update && !file_exists($tmp_path.DS.$fulldetails->filename)) {
		echo ' - <a href="'. $fulldetails->url .'" target="_blank">Télécharger le fichier dans le répertoire temporaire</a>';
	}
	?></li>
	<?php if($patchdetails) { ?>
	<li><a
		href="index.php?option=com_jupdateman&task=step2&target=patch">Le package de mise à jour</a> (<?php echo round($patchdetails->filesize/1024/1024,2) ?>MB)<?php
	if($cached_update && !file_exists($tmp_path.DS.$patchdetails->filename)) {
		echo ' - <a href="'. $patchdetails->url .'" target="_blank">Télécharger le fichier dans le répertoire temporaire</a>';
	}
	?></li>
	<?php } ?>
</ul>
<p>Note: Le package de mise à jour contient uniquement les fichiers modifiés et sont adaptés pour la plupart des correctifs. Des améliorations majeures (par exemple, passage de 1.5.x vers la 1.6) auront probablement besoin d'un package complet.</p>
<?php if($cached_update) : ?>
	<p style="font-weight:bold">Note: Vous utilisez le mode de mise à jour du cache. Vous aurez à charge la mise à jour des fichiers dans le répertoire temporaire avant de continuer</p>
	<p>Votre répertoire temporaire: <span style="font-style:italic"><?php echo $tmp_path ?></span></p>
	<?php
endif;
