<?php
/** ****************************************************************
 * This file is part of SecurityImages for Joomla!.
 *
 * SecurityImages is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.

 * Foobar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package		SecurityImages
 * @copyright	Copyright (C) 2004 - 2008 Cdric Walter. All rights reserved.
 *******************************************************************/

defined( '_JEXEC' ) or die( 'Restricted access' );

require_once(dirname( __FILE__ ).DS.'config.php');

/**
 * TO edit and change language file
 *
 */
class SecurityImagesLanguage extends JObject {

    /**
     * Constructor
     *
     * @return SecurityImagesLanguage
     */
	function SecurityImagesLanguage() {
	}

	/**
	 * maybe joomla 1.5 has an editor for plugins?
	 * @param unknown_type $option
	 */
	function showLanguage($option) {
		$lang		=& JFactory::getLanguage();
		$langTag = $lang->getTag();
	
		$file = JPATH_SITE.DS.'administrator'.DS.'language'.DS.$langTag.DS.$langTag.'.com_securityimages.ini';	
	
		//fallback to english
		if (!file_exists($file)) {
		  $file = JPATH_SITE.DS.'administrator'.DS.'language'.DS.'en-GB'.DS.'en-GB.com_securityimages.ini';	
		}
		
		
		@ chmod($file, 0766);
		$permission = is_writable($file);
		if (!$permission) {
			echo "<center><h1><font color=red>Warning...</FONT></h1><BR>";
			echo "<B>".JText::_('SECURITY_IMAGES_CHMOD_766')."</B></center><BR />";
		}

		$SecurityImagesConfig = & new SecurityImagesConfig();
		$SecurityImagesConfig->showFile($file, $option);
	}
	
	/**
	 * 
	 * @param unknown_type $file
	 * @param unknown_type $filecontent
	 * @param unknown_type $option
	 */
	function saveLanguage($file, $filecontent, $option) {
		global $mainframe;
	
		@ chmod($file, 0766);
		$permission = is_writable($file);
		if (!$permission) {
			$mainframe->redirect("index2.php?option=$option&task=editgenerallanguage", JText::_('SECURITY_IMAGES_CHMOD_766'));
			break;
		}

		if ($fp = fopen($file, "w")) {
			fputs($fp, stripslashes($filecontent));
			fclose($fp);
			$mainframe->redirect("index2.php?option=$option&task=editgenerallanguage", JText::_('SECURITY_IMAGES_Language_Saved_in').$file);
		}
	}

}
?>

