<?php
/**
 * Helper File
 *
 * @package    Modalizer
 * @version    1.2.3
 * @since      File available since Release 1.0.0
 *
 * @author     Peter van Westen <peter@nonumber.nl>
 * @link       http://www.nonumber.nl/modalizer
 * @copyright  Copyright (C) 2008 NoNumber! All Rights Reserved
 * @license    http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

// Ensure this file is being included by a parent file
defined( '_JEXEC' ) or die( 'Restricted access' );

class plgSystemModalizerHelper {
	function returnParams( $_params )
	{
		global $mainframe;

		$params['is_modalwindow']		= ( JRequest::getCmd( 'ml', 0 ) ) ? 1 : 0;
		$params['allow_plugin']			= 0;
		$params['allow_modals']			= 0;

		$_document	=& JFactory::getDocument();
		$_docType = $params['doctype'] = $_document->getType();

		if( $mainframe->isAdmin() ) {
			$_option = JRequest::getCmd('option');

			if ( $_option == 'com_plugins' ) {
				$cid 	= JRequest::getVar( 'cid', array(0), '', 'array' );
				JArrayHelper::toInteger($cid, array(0));
				$_plugin = JTable::getInstance('plugin');
				$_plugin->load( $cid[0] );
				if( $_plugin->element == 'modalizer' ) {
					$params['allow_plugin'] = 1;
				}
			}
		} else {
			$params['allow_plugin'] = 1;
			if ( ( !$this->params['is_modalwindow'] || (
					$this->params['type'] == 'highslide' ||
					$this->params['type'] == 'shadowbox'
				) )
			) {
				$params['allow_modals'] = 1;
			}
		}

		$params['is_admin']				= ( $mainframe->isAdmin() ) ? 1 : 0;

		$params['set_maintemplate']		= JRequest::getCmd( 'mlt', '' );

		$params['type'] 				= JRequest::getCmd( 'ml', $this->_params->get( 'type', 'squeezebox' ) );
		$params['type'] 				= plgSystemModalizerHelper::getWindowType( $params['type'] );
		$params['type_list'] 			= 'fancybox,greybox,highslide,shadowbox,squeezebox,thickbox';


		$_type_array = explode( ',', $params['type_list'] );
		$params['type_params']				= array();
		foreach( $_type_array as $_type ) {
			$params['type_params'][$_type]	= plgSystemModalizerHelper::getDefaultParamsByType( $_type );
		}

		$templates 						= $this->_params->get( 'templates', 'system:component' );
		$templates 						= explode( ':', $templates );

		$params['maintemplate']			= JRequest::getCmd( 'mlt', $templates[0] );
		$params['subtemplate']			= JRequest::getCmd( 'tmpl', $templates[1] );

		$params['enable_modal_syntax']	= $this->_params->get( 'enable_modal_syntax', 1 );
		$params['enable_classes']		= $this->_params->get( 'enable_classes', 1 );
		$params['enable_blank']			= $this->_params->get( 'enable_blank', 1 );
		
		$params['inc_mootools']			= $this->_params->get( 'inc_mootools', 1 );
		$params['inc_jquery']			= $this->_params->get( 'inc_jquery', 1 );

		$params['protect_start'] 		= 'ML_STRING_PROTECTION_START';
		$params['protect_end'] 			= 'ML_STRING_PROTECTION_END';

		return $params;
	}

	function getDefaultParamsByType( $type = '' )
	{
		$params = array();

		// Overall params
		$params['width'] = $this->_params->get( 'width', 600 );
		$params['height'] = $this->_params->get( 'height', 400 );

		$params['overlay'] = $this->_params->get( 'overlay', 1 );
		$params['overlay_close'] = $this->_params->get( 'overlay_close', 1 );
		$params['overlay_opacity'] = $this->_params->get( 'overlay_opacity', 0.7 );

		// Specific Type params
		switch( $type ) {
			case 'fancybox':
				$params['speed_in'] = $this->_params->get( 'fancybox_speed_in', 500 );
				$params['speed_out'] = $this->_params->get( 'fancybox_speed_out', 500 );
				break;
			case 'greybox':
				$params['behavior'] = $this->_params->get( 'greybox_behavior', '' );
				break;
			case 'highslide':
				$params['auto_size'] = $this->_params->get( 'highslide_auto_size', 1 );
				$params['speed_in'] = $this->_params->get( 'highslide_speed_in', 250 );
				$params['speed_out'] = $this->_params->get( 'highslide_speed_out', 250 );
				$params['outline'] = $this->_params->get( 'highslide_outline', '' );
				break;
			case 'shadowbox':
				$params['animate'] = $this->_params->get( 'shadowbox_animate', 1 );
				$params['animateFade'] = $this->_params->get( 'shadowbox_animateFade', 1 );
				$params['animSequence'] = $this->_params->get( 'shadowbox_animSequence', 'wh' );
				break;
			case 'thickbox':
				break;
			case 'squeezebox':
			default:
				break;
		}
		return $params;
	}

	function placeModalScripts( $body )
	{
		$_root = JURI::root( true );
		$_abs_root = JURI::root( false );

		// Include the the different modal scripts/css if necessary
		// FancyBox
		if ( !( strpos( $body,'class="nn_fancybox' ) === false ) ) {
			$body = plgSystemModalizerHelper::placeScript( $body, 'jquery' );
			if( ( strpos( $body,'/nn_fancybox.js' ) === false ) ) {
				$body = str_replace( '</head>', "\t".'<script type="text/javascript" src="'.$_root.'/plugins/system/modalizer/modals/fancybox/nn_fancybox.js"></script>'."\n</head>", $body );
			}
			if( ( strpos( $body,'/nn_fancybox.css' ) === false ) ) {
				$body = str_replace( '</head>', "\t".'<link rel="stylesheet" href="'.$_root.'/plugins/system/modalizer/modals/fancybox/nn_fancybox.css" type="text/css" />'."\n</head>", $body );
			}
		}

		// GreyBox
		if ( !( strpos( $body,'rel="nn_greybox_' ) === false ) ) {
			$body = plgSystemModalizerHelper::placeScript( $body, 'mootools' );
			if( ( strpos( $body,'/nn_greybox.js' ) === false ) ) {
				$body = str_replace( '</head>', "\t".
					'<script type="text/javascript">var GB_ROOT_DIR = "'.$_abs_root.'plugins/system/modalizer/modals/greybox/";</script>'."\n\t".
					'<script type="text/javascript" src="'.$_root.'/plugins/system/modalizer/modals/greybox/nn_greybox_ajs.js"></script>'."\n\t".
					'<script type="text/javascript" src="'.$_root.'/plugins/system/modalizer/modals/greybox/nn_greybox_ajs_fx.js"></script>'."\n\t".
					'<script type="text/javascript" src="'.$_root.'/plugins/system/modalizer/modals/greybox/nn_greybox.js"></script>'.
					"\n</head>", $body );
			}
			if( ( strpos( $body,'/nn_greybox.css' ) === false ) ) {
				$body = str_replace( '</head>', "\t".'<link rel="stylesheet" href="'.$_root.'/plugins/system/modalizer/modals/greybox/nn_greybox.css" type="text/css" />'."\n</head>", $body );
			}
		}

		// HighSlide
		if ( !( strpos( $body,'nn_hs.htmlExpand' ) === false ) ) {
			$body = plgSystemModalizerHelper::placeScript( $body, 'mootools' );
			if( ( strpos( $body,'/nn_highslide.js' ) === false ) ) {
				$body = str_replace( '</head>', "\t".
					'<script type="text/javascript" src="'.$_root.'/plugins/system/modalizer/modals/highslide/nn_highslide.js"></script>'."\n\t".
					'<script type="text/javascript">nn_hs.graphicsDir = \''.$_root.'/plugins/system/modalizer/modals/highslide/images/\';</script>'.
					"\n</head>", $body );
			}
			if( ( strpos( $body,'/nn_highslide.css' ) === false ) ) {
				$body = str_replace( '</head>', "\t".'<link rel="stylesheet" href="'.$_root.'/plugins/system/modalizer/modals/highslide/nn_highslide.css" type="text/css" />'."\n</head>", $body );
			}
		}

		// ShadowBox
		if ( !( strpos( $body,'rel="nn_shadowbox' ) === false ) ) {
			$body = plgSystemModalizerHelper::placeScript( $body, 'mootools' );
			$_params = $this->params['type_params']['shadowbox'];
			if( ( strpos( $body,'/nn_shadowbox.js' ) === false ) ) {
				$body = str_replace( '</head>', "\t".
				'<script type="text/javascript" src="'.$_root.'/plugins/system/modalizer/modals/shadowbox/nn_shadowbox-mootools.js"></script>'."\n\t".
				'<script type="text/javascript" src="'.$_root.'/plugins/system/modalizer/modals/shadowbox/nn_shadowbox.js"></script>'."\n\t".
				'<script type="text/javascript" src="'.$_root.'/plugins/system/modalizer/modals/shadowbox/nn_shadowbox-skin.js"></script>'.
				"\n</head>", $body );
			}
			if( ( strpos( $body,'/nn_shadowbox.css' ) === false ) ) {
				$body = str_replace( '</head>', "\t".'<link rel="stylesheet" href="'.$_root.'/plugins/system/modalizer/modals/shadowbox/nn_shadowbox.css" type="text/css" />'."\n</head>", $body );
			}
		}

		// SqueezeBox
		if ( !( strpos( $body,'class="nn_squeezebox' ) === false ) ) {
			$body = plgSystemModalizerHelper::placeScript( $body, 'mootools' );
			if( ( strpos( $body,'/nn_squeezebox.js' ) === false ) ) {
				$body = str_replace( '</head>', "\t".'<script type="text/javascript" src="'.$_root.'/plugins/system/modalizer/modals/squeezebox/nn_squeezebox.js"></script>'."\n</head>", $body );
			}
			if( ( strpos( $body,'/nn_squeezebox.css' ) === false ) ) {
				$body = str_replace( '</head>', "\t".'<link rel="stylesheet" href="'.$_root.'/plugins/system/modalizer/modals/squeezebox/nn_squeezebox.css" type="text/css" />'."\n</head>", $body );
			}
		}

		// ThickBox
		if ( !( strpos( $body,'class="nn_thickbox' ) === false ) ) {
			$body = plgSystemModalizerHelper::placeScript( $body, 'jquery' );
			if( ( strpos( $body,'/nn_thickbox.js' ) === false ) ) {
				$body = str_replace( '</head>', "\t".'<script type="text/javascript" src="'.$_root.'/plugins/system/modalizer/modals/thickbox/nn_thickbox.js"></script>'."\n</head>", $body );
			}
			if( ( strpos( $body,'/nn_thickbox.css' ) === false ) ) {
				$body = str_replace( '</head>', "\t".'<link rel="stylesheet" href="'.$_root.'/plugins/system/modalizer/modals/thickbox/nn_thickbox.css" type="text/css" />'."\n</head>", $body );
			}
		}


		return $body;
	}
	
	function placeScript( $str = '', $type = 'mootools' )
	{
		$_root = JURI::root( true );
		switch ( $type ) {
			case 'jquery':		
				if( $this->params['inc_jquery'] && ( strpos( $str,'/nn_jquery.js' ) === false ) ) {
					$str = str_replace( '</head>', "\t".'<script type="text/javascript" src="'.$_root.'/plugins/system/modalizer/modals/nn_jquery.js"></script>'."\n</head>", $str );
				}
				break;
			case 'mootools':
			default:
				if ( $this->params['inc_mootools'] ) {
					$str = str_replace( 'media/system/js/mootools.js', 'plugins/system/modalizer/modals/nn_mootools.js', $str );
				}			
				break;
		}
		return $str;	
	}

	function modalizeLink( $type = '', $link = '', $params = array() )
	{
		if ( $type == '' ) { $type = $this->params['type']; }

		$_link_attribs = plgSystemModalizerHelper::getTagAttribs( $link, 'a' );
		if ( isset( $params['title'] ) ) {
			$_link_attribs['title']  = $params['title'];
		} else if( $this->_params->get( 'add_title', 1 ) && !isset( $_link_attribs['title'] ) || !$_link_attribs['title'] ) {
			$_link_attribs['title'] = plgSystemModalizerHelper::getLinkTitle($link);
		}

		// Return if link is already modalized
		if ( isset( $_link_attribs['rev'] ) && $_link_attribs['rev'] == 'ml' ) { return $link; }

		// Return if href is not set
		$_url = '';
		if ( isset( $params['href'] ) ) {
			$_url = $params['href'];
		} else if ( isset( $_link_attribs['href'] ) ) {
			$_url = $_link_attribs['href'];
		}
		if ( !$_url ) { return $link; }

		// Remove emty values
		$params = plgSystemModalizerHelper::arrayFilterEmpty( $params );
		// Set default params if not already set
		$_type_defaults = $this->params['type_params'][$type];
		$params = array_merge( $_type_defaults, $params );

		$_link_is_internal = plgSystemModalizerHelper::urlIsInternal( $_url );

		$_url_vars = array();
		// Set default url vars
		if ( $_link_is_internal ) {
			$_url_vars['ml'] = plgSystemModalizerHelper::getWindowTypeNr( $type );
			$_url_vars['mlt'] = ( isset ( $params['maintemplate'] ) ) ? $params['maintemplate'] : $this->params['maintemplate'];
			$_url_vars['tmpl'] = ( isset ( $params['subtemplate'] ) ) ? $params['subtemplate'] : $this->params['subtemplate'];
		}

		// Set default link attributes
		$_link_attribs['target'] = '_blank';
		$_link_attribs['rev'] = 'ml';
		$_link_attribs['onclick'] = '';

		$_p = array();
		switch( $type ) {
			case 'fancybox':
				$_link_attribs['class'] = ( isset( $_link_attribs['class'] ) ) ? 'nn_fancybox '.$_link_attribs['class'] : 'nn_fancybox';
				if ( $params['width'] != 600 ) { $_p[] = 'frameWidth:'.$params['width']; }
				if ( $params['height'] != 400 ) { $_p[] = 'frameHeight:'.$params['height']; }
				if ( !$params['overlay'] ) {
					$_p[] = 'overlayShow:false';
				} else {
					if ( !$params['overlay_close'] ) { $_p[] = 'closeWithOverlay:false'; }
					if ( $params['overlay_opacity'] != 0.7 ) { $_p[] = 'overlayOpacity:'.$params['overlay_opacity']; }
				}
				if ( $params['speed_in'] != 500 ) { $_p[] = 'zoomSpeedIn:'.$params['speed_in']; }
				if ( $params['speed_out'] != 500 ) { $_p[] = 'zoomSpeedOut:'.$params['speed_out']; }
				$_link_attribs['rel'] = '{'.implode( ';', $_p ).'}';
				break;
			case 'greybox':
				if ( $params['behavior'] == 'set' ) {
					$_link_attribs['rel'] = 'nn_greybox_pageset[group;'.$params['overlay'].';'.$params['overlay_close'].';'.$params['overlay_opacity'].']';
				} else {
					$_link_attribs['rel'] = 'nn_greybox_page'.$params['behavior'].'['.$params['width'].';'.$params['height'].';'.$params['overlay'].';'.$params['overlay_close'].';'.$params['overlay_opacity'].']';
				}
				break;
			case 'highslide':
				$_p[] = 'objectType:\'iframe\'';
				$_outline = ( isset( $params['outline'] ) ) ? $params['outline'] : $this->_params->get( 'outline', '' );
				if ( $_outline ) {
					$_p[] = 'outlineType:\''.$_outline.'\'';
				}
				if ( !$_link_is_internal ) {
					$_p[] = 'width:'.$params['width'];
					$_p[] = 'height:'.$params['height'];
				}
				if ( $params['speed_in'] != 250 ) { $_p[] = 'expandDuration:'.$params['speed_in']; }
				if ( $params['speed_out'] != 250 ) { $_p[] = 'restoreDuration:'.$params['speed_out']; }
				if ( !$params['auto_size'] ) {
					$_p[] = 'width:'.$params['width'];
					$_p[] = 'height:'.$params['height'];
				}
				$_link_attribs['onclick'] = 'return nn_hs.htmlExpand(this, { '.implode( ',', $_p ).' } )';
				break;
			case 'shadowbox':
				if ( !$params['animate'] ) { $_p[] = 'animate:false'; }
				if ( !$params['animateFade'] ) { $_p[] = 'animateFade:false'; }
				if ( $params['animSequence'] != 'wh' ) { $_p[] = 'animSequence:\''.$params['animSequence'].'\''; }
				if ( !$params['overlay'] ) {
					$_p[] = 'showOverlay:false';
				} else {
					if ( !$params['overlay_close'] ) { $_p[] = 'modal:true'; }
					if ( $params['overlay_opacity'] != 0.7 ) { $_p[] = 'overlayOpacity:'.$params['overlay_opacity']; }
				}
				$_link_attribs['rel'] = 'nn_shadowbox{'.implode( ',', $_p ).'}';
				break;
			case 'thickbox':
				$_url_vars['KeepThis'] = 'true';
				$_url_vars['TB_iframe'] = 'true';
				$_url_vars['width'] = $params['width'];
				$_url_vars['height'] = $params['height'];
				if ( !$params['overlay'] ) {
					$_url_vars['overlay'] = 'false';
				} else {
					if ( !$params['overlay_close'] ) { $_url_vars['overlay_close'] = 'false'; }
					if ( $params['overlay_opacity'] != 0.7 ) { $_url_vars['overlay_opacity'] = $params['overlay_opacity']; }
				}
				$_link_attribs['class'] = ( isset( $_link_attribs['class'] ) ) ? 'nn_thickbox '.$_link_attribs['class'] : 'nn_thickbox';
				break;
			case 'squeezebox':
			default:
				$_link_attribs['class'] = ( isset( $_link_attribs['class'] ) ) ? 'nn_squeezebox '.$_link_attribs['class'] : 'nn_squeezebox';
				$_p[] = 'handler:\'iframe\'';
				$_p[] = 'size:{x:'.$params['width'].',y:'.$params['height'].'}';
				if ( !$params['overlay'] ) {
					$_p[] = 'showOverlay:false';
				} else {
					if ( !$params['overlay_close'] ) { $_p[] = 'closeWithOverlay:false'; }
					if ( $params['overlay_opacity'] != 0.7 ) { $_p[] = 'overlayOpacity:'.$params['overlay_opacity']; }
				}
				$_link_attribs['rel'] = '{'.implode( ',', $_p ).'}';
				break;
		}

		$_url = plgSystemModalizerHelper::setUrl( $_url, $_url_vars );
		$_link_attribs['href'] = $_url;

		$link = plgSystemModalizerHelper::setLink( $link, $_link_attribs );

		return $link;
	}

	function modalizeIconLink( $link, $icon_type = 'print' )
	{
		$_params = array();
		$_params['width'] = $this->_params->get( $icon_type.'_width' );
		$_params['height'] = $this->_params->get( $icon_type.'_height' );
		$_params['overlay_close'] = $this->_params->get( $icon_type.'_overlay_close' );
		$link = plgSystemModalizerHelper::modalizeLink( '', $link, $_params );
		return $link;
	}
	
	function modalizeClassLink( $link )
	{
		$link = plgSystemModalizerHelper::modalizeLink( '', $link );
		return $link;
	}
	
	function modalizeBlankLink( $link )
	{
		$_link_attribs = plgSystemModalizerHelper::getTagAttribs( $link, 'a' );
		
		// Return if href is not set
		if( !isset( $_link_attribs['href'] ) ) { return $link; }

		// Return if href is not a real link (empty, ancor, javascript)
		$_url = $_link_attribs['href'];
		if ( !$_url || $_url == '#' || strpos( $_url, 'javascript:' ) === 0 ) { return $link; }

		// Return if link in-/external is not enabled
		$_link_is_internal = plgSystemModalizerHelper::urlIsInternal( $_url );
		if ( ( $_link_is_internal && $this->params['enable_blank'] == 2 ) || ( !$_link_is_internal && $this->params['enable_blank'] == 1 ) ) { return $link; }

		// Return if not pass file type check
		$_disable_types = $this->_params->get( 'disable_types', 'avi,mov,mp3,zip' );
		if ( !plgSystemModalizerHelper::passFileTypeCheck( $_url ) ) { return $link; }
			
		$link = plgSystemModalizerHelper::modalizeLink( '', $link );
		
		return $link;
	}

	function checkUrlIconType( $url, $type = 'print' )
	{
		switch( $type ) {
			case 'email':
				$_identifiers = $this->_params->get( 'email_identifiers', 'mailto,/email.html' );
				break;
			case 'pdf':
				$_identifiers = $this->_params->get( 'pdf_identifiers', 'format=pdf,/pdf.html' );
				break;
			default:
				$_identifiers = $this->_params->get( 'print_identifiers', 'print=1,/print.html' );
				break;
		}
		$_identifiers = explode( ',', $_identifiers );
		foreach ( $_identifiers as $_identifier ) {
			if ( !strpos( $url, trim( $_identifier ) ) === false ) {
				return 1;
			}
		}

		return 0;
	}

	function passClassCheck( $linkClasses = '' )
	{
		// array with trimmed classes that should be checked
		$linkClassesArray = array_map( 'trim', explode( ' ', $linkClasses ) );
		
		// classes that pass the check
		$classes = $this->_params->get( 'classes', 'modal' );
		// array with trimmed classes that pass the check
		$classesArray = array_map( 'trim', explode( ',', $classes ) );
		
		$passCheck = ( count( array_intersect( $linkClassesArray, $classesArray ) ) == 0 ) ? 0 : 1;
		
		return $passCheck;
	}
	
	function passBlankCheck( $link )
	{
		$_link_attribs = plgSystemModalizerHelper::getTagAttribs( $link, 'a' );
		// Return true if target is _blank
		if( isset( $_link_attribs['target'] ) && $_link_attribs['target'] == '_blank' ) { return 1; }

		return 0;
	}
	
	function passFileTypeCheck( $url, $file_types = '' )
	{
		if( !strrpos( $url, '.' ) === false ) {
			$_url_file_type = substr( $url, strrpos( $url, '.' )+1 );
			$file_types = explode( ',', $file_types );
			foreach ( $file_types as $_file_type ) {
				if ( $_url_file_type == trim( $_file_type ) ) {
					return 0;
				}
			}
		}

		return 1;
	}

	/*
	 * function setUrl
	 * returns a string of the url and attached vars
	 */
	function setUrl( $url, $vars = array() )
	{
		$_url_array = plgSystemModalizerHelper::getUrlVars( $url );
		$_vars = array_merge( $_url_array[1], $vars );

		if ( count( $_vars ) ) {
			$_vars_array = array();
			foreach ( $_vars as $_var_key => $_var_val ) {
				$_vars_array[] = $_var_key.'='.$_var_val;
			}
			$url = $_url_array[0].'?'.implode( '&', $_vars_array );
			$url = JFilterOutput::ampReplace( $url );
		}

		return $url;
	}

	function setUrlDefaults( $url )
	{
		$url_vars['ml'] = plgSystemModalizerHelper::getWindowTypeNr( $this->params['type']  );
		$url_vars['mlt'] = $this->params['maintemplate'];
		$url_vars['tmpl'] = $this->params['subtemplate'];

		return plgSystemModalizerHelper::setUrl( $url, $url_vars );
	}

	/*
	 * function setLink
	 * returns a string of the link with the correct href and other attributes
	 */
	function setLink( $link, $attribs = array() )
	{
		$_link_array = plgSystemModalizerHelper::getTagAttribs( $link, 'a' );
		$_attribs = array_merge( $_link_array, $attribs );

		$_regex = '#<a\s.+?>(.*?)</a>#si';
		preg_match( $_regex, $link, $_match );
		$_content = $_match[1];

		if ( $this->_params->get( 'add_title', 1 ) && !isset( $_attribs['title'] ) || !$_attribs['title'] ) {
			$_attribs['title'] = plgSystemModalizerHelper::getLinkTitle( $link );
		}

		if ( !$_content && isset( $_attribs['title'] ) ) {
			$_content = $_attribs['title'];
		}

		$link = '<a';
		foreach ( $_attribs as $_att_key => $att_val ) {
			if ( $att_val ) {
				$link .= ' '.$_att_key.'="'.$att_val.'"';
			}
		}
		$link .= '>'.$_content.'</a>';

		return $link;
	}

	/*
	 * function setLink
	 * returns a string of the link with the correct href and other attributes
	 */
	function getLinkTitle( $link )
	{
		$_link_attribs = plgSystemModalizerHelper::getTagAttribs( $link, 'a' );

		$_title = '';
		if ( isset( $_link_attribs['title'] ) && $_link_attribs['title'] ) {
			$_title = $_link_attribs['title'];
		} else if ( $this->_params->get( 'add_title', 1 ) ) {
			$_regex = '#<a\s.+?>(.*?)</a>#si';
			preg_match( $_regex, $link, $_match );
			$_content = $_match[1];
			if ( $_content ) {
				$_title = preg_replace( '#<.*?>#s', '', $_content );
				if ( !$_title ) {
					$_content_array = plgSystemModalizerHelper::getTagAttribs( $_content );
					foreach ( $_content_array as $_link_attribs ) {
						if ( isset( $_link_attribs['title'] ) ) {
							$_title = $_link_attribs['title'];
							break;
						}
					}
					if ( !$_title ) {
						foreach ( $_content_array as $_link_attribs ) {
							if ( isset( $_link_attribs['alt'] ) ) {
								$_title = $_link_attribs['alt'];
								break;
							}
						}
					}
				}
				$_title = htmlentities( $_title );
			}
		}

		return $_title;
	}

	/*
	 * function getUrlVars
	 * returns an array with
	 * 1) the url part without vars
	 * 2) an array with all the vars
	 */
	function getUrlVars( $url )
	{
		$url = JFilterOutput::ampReplace( $url );
		$url = str_replace( '&amp;', '&', $url );

		$url_array = array();

		if ( strpos( $url, '?' ) === false ) {
			if ( strpos( $url, '&' ) === false ) {
				// url does not contain vars
				$url_array[] = $url;
				$_url_vars = '';
			} else {
				// url consists of only vars
				$url_array[] = '';
				$_url_vars = $url;
			}
		} else {
			// url contains vars
			$url_array[] = substr( $url, 0, strpos( $url, '?' ) );
			$_url_vars = substr( $url, strpos( $url, '?' )+1 );

		}

		$_url_var_array = array();
		if ( $_url_vars ) {
			$_var_array = explode( '&', $_url_vars );

			foreach ( $_var_array as $_url_var ) {
				if ( strpos( $_url_var, '=' ) === false ) {
					$_url_var_key = $_url_var;
					$_url_var_val = '';
				} else {
					$_url_var_key = substr( $_url_var, 0, strpos( $_url_var, '=' ) );
					$_url_var_val = substr( $_url_var, strpos( $_url_var, '=' )+1 );
				}
				if ( !isset( $_url_var_array[$_url_var_key] ) ) {
					$_url_var_array[$_url_var_key] = $_url_var_val;
				}
			}
		}
		$url_array[] = $_url_var_array;

		return $url_array;
	}

	/*
	 * function getTagAttribs
	 * returns an array with with all attributes
	 */
	function getTagAttribs( $tag, $tagname = '' )
	{
		$_fulltag = 1;

		$_tag_attrib_array = array();

		if ( strpos( $tag, '<' ) === 0 ) {
			$_regex = '#<([[:alnum:]_-]+?)\s(.+?)>#si';
			if ( preg_match_all( $_regex, $tag, $_matches, PREG_SET_ORDER ) > 0 ) {
				foreach ( $_matches as $_match ) {
					$_tag_attrib_array[ $_match[1] ] = $_match[2];
				}
			} else {
				$_tag_attrib_array[] = $tag;
				$_fulltag = 0;
			}
		} else {
			$_tag_attrib_array[] = $tag;
			$_fulltag = 0;
		}

		$tag_attrib_array = array();
		foreach ( $_tag_attrib_array as $_tag_name => $_tag_attribs ) {
			$_current_tag_array = array();
			// add leading and trailing space to be able match first attribute and attributes without quotes
			$_tag_attribs = ' '.$_tag_attribs.' ';
			// regular expressio that matches all attributes
			// with or without single/double quotes
			 $_regex = '#\s([[:alnum:]_-]+?)=(?=(?="(.+?)")|(?=\'(.+?)\')|(?=([^ ]+?) ))#si';
			if ( preg_match_all( $_regex, $_tag_attribs, $_matches, PREG_SET_ORDER ) > 0 ) {
				foreach ( $_matches as $_match ) {
					if ( !isset( $_current_tag_array[$_match[1]] ) ) {
						// remove empty values
						$_match = plgSystemModalizerHelper::arrayFilterEmpty( $_match );
						// renumber array
						$_match = array_values( $_match );
						if ( array_key_exists( '2', $_match ) ) {
							$_current_tag_array[$_match[1]] = $_match[2];
						}
					}
				}
			}
			$tag_attrib_array[$_tag_name] = $_current_tag_array;

		}
		if ( !$_fulltag ) {
			$tag_attrib_array[0];
		} else if ( $tagname ) {
			return $tag_attrib_array[$tagname];
		}
		return $tag_attrib_array;
	}

	function urlIsInternal( $url )
	{
		// hostname: give preference to SERVER_NAME, because this includes subdomains
		$hostname = ( $_SERVER['SERVER_NAME'] ) ? $_SERVER['SERVER_NAME'] : $_SERVER['HTTP_HOST'];
		$is_internal = ( !( strpos( $url , $hostname ) === false ) || ( strpos( $url, '://' ) === false ) ) ? 1 : 0;
		return $is_internal;
	}

	function getWindowType( $type )
	{
		$window_type = $this->_params->get( 'type', 'squeezebox' );
		$_type_list = $this->params['type_list'];
		$_type_array = explode( ',', $_type_list );

		if ( !( strpos( $type, 'fancy' ) === false ) || ( (int) $type && (int) $type == array_search( 'fancybox', $_type_array ) + 1 ) ) {
			$window_type = 'fancybox';
		} else if ( !( strpos( $type, 'greybox' ) === false ) || ( (int) $type && (int) $type == array_search( 'greybox', $_type_array ) + 1 ) ) {
			$window_type = 'greybox';
		} else if ( !( strpos( $type, 'highslide' ) === false ) || ( (int) $type && (int) $type == array_search( 'highslide', $_type_array ) + 1 ) ) {
			$window_type = 'highslide';
		} else if ( !( strpos( $type, 'shadow' ) === false ) || ( (int) $type && (int) $type == array_search( 'shadowbox', $_type_array ) + 1 ) ) {
			$window_type = 'shadowbox';
		} else if ( !( strpos( $type, 'squeeze' ) === false ) || ( (int) $type && (int) $type == array_search( 'squeezebox', $_type_array ) + 1 ) ) {
			$window_type = 'squeezebox';
		} else if ( !( strpos( $type, 'thickbox' ) === false ) || ( (int) $type && (int) $type == array_search( 'thickbox', $_type_array ) + 1 ) ) {
			$window_type = 'thickbox';
		}

		return $window_type;
	}

	function getWindowTypeNr( $type )
	{
		$_type_list = $this->params['type_list'];
		$_type_array = explode( ',', $_type_list );

		$type = plgSystemModalizerHelper::getWindowType( $type );
		$type = array_search( $type, $_type_array ) + 1;
		if ( $type ) { return $type; }

		$type = $this->params['type_list'];
		$type = array_search( $type, $_type_array  ) + 1;
		if ( $type ) { return $type; }

		return 1;
	}

	function convertModalSyntax( $str = '' )
	{
		// Modalizer syntax tags
		if ( !( strpos( $str, '{modal' ) === false ) ) {
			$regex = '#{(modal(?:inks|izer)?) ([^}]*?=[^}]*?)}(.+?){/\1}#s';
			if ( preg_match_all( $regex, $str, $matches, PREG_SET_ORDER ) > 0 ) {
				foreach ( $matches as $match ) {
					$_tag_params_array = explode( "|", $match[2] );
					$_tag_params = array();
					foreach ( $_tag_params_array as $_tag_param ) {
						if ( !strpos( $_tag_param, '=' ) === false ) {
							// url contains vars
							$_key = trim( substr( $_tag_param, 0, strpos( $_tag_param, '=' ) ) );
							$_val = trim( substr( $_tag_param, strpos( $_tag_param, '=' )+1 ) );
							if ( strlen( $_val ) ) {
								$_tag_params[$_key] =  $_val;
							}
						}
					}

					if ( isset( $_tag_params['link'] ) && $_tag_params['link'] ) {
						$_tag_params['href'] = $_tag_params['link'];
						unset( $_tag_params['link'] );
					} else if ( isset( $_tag_params['url'] ) && $_tag_params['url'] ) {
						$_tag_params['href'] = $_tag_params['url'];
						unset( $_tag_params['url'] );
					}
					
					if ( isset( $_tag_params['href'] ) && $_tag_params['href'] ) {
						// modal window settings
						$_type = $this->params['type'];
						if ( isset( $_tag_params['type'] ) && $_tag_params['type'] ) {
							$_type = $_tag_params['type'];
							unset( $_tag_params['type'] );
						} else if ( isset( $_tag_params['windowtype'] ) && $_tag_params['windowtype'] ) {
							$_type = $_tag_params['windowtype'];
							unset( $_tag_params['windowtype'] );
						}

						$_type = plgSystemModalizerHelper::getWindowType( strtolower( $_type ) );
						// templates
						if ( !isset( $_tag_params['maintemplate'] ) ) {
							if ( isset( $_tag_params['template'] ) && $_tag_params['template'] ) {
								$_tag_params['maintemplate'] = $_tag_params['template'];
								unset( $_tag_params['template'] );
							}
						}
						if ( !isset( $_tag_params['subtemplate'] ) ) {
							if ( isset( $_tag_params['tmpl'] ) && $_tag_params['tmpl'] ) {
								$_tag_params['subtemplate'] = $_tag_params['tmpl'];
								unset( $_tag_params['tmpl'] );
							}
						}

						if ( !isset( $_tag_params['width'] ) ) {
							if ( isset( $_tag_params['w'] ) && $_tag_params['w'] ) {
								$_tag_params['width'] = $_tag_params['w'];
								unset( $_tag_params['w'] );
							}
						}
						if ( !isset( $_tag_params['height'] ) ) {
							if ( isset( $_tag_params['h'] ) && $_tag_params['h'] ) {
								$_tag_params['height'] = $_tag_params['h'];
								unset( $_tag_params['h'] );
							}
						}

						if ( !isset( $_tag_params['overlay'] ) ) {
							if ( isset( $_tag_params['show_overlay'] ) && $_tag_params['show_overlay'] ) {
								$_tag_params['overlay'] = $_tag_params['show_overlay'];
								unset( $_tag_params['show_overlay'] );
							} else if ( isset( $_tag_params['showOverlay'] ) && $_tag_params['showOverlay'] ) {
								$_tag_params['overlay'] = $_tag_params['showOverlay'];
								unset( $_tag_params['showOverlay'] );
							}
						}
						if ( !isset( $_tag_params['overlay_close'] ) ) {
							if ( isset( $_tag_params['close'] ) && $_tag_params['close'] ) {
								$_tag_params['overlay_close'] = $_tag_params['close'];
								unset( $_tag_params['close'] );
							} else if ( isset( $_tag_params['close_overlay'] ) && $_tag_params['close_overlay'] ) {
								$_tag_params['overlay_close'] = $_tag_params['close_overlay'];
								unset( $_tag_params['close_overlay'] );
							} else if ( isset( $_tag_params['closeWithOverlay'] ) && $_tag_params['closeWithOverlay'] ) {
								$_tag_params['overlay_close'] = $_tag_params['closeWithOverlay'];
								unset( $_tag_params['closeWithOverlay'] );
							}
						}
						if ( !isset( $_tag_params['overlay_opacity'] ) ) {
							if ( isset( $_tag_params['opacity'] ) && $_tag_params['opacity'] ) {
								$_tag_params['overlay_opacity'] = $_tag_params['opacity'];
								unset( $_tag_params['opacity'] );
							} else if ( isset( $_tag_params['overlayOpacity'] ) && $_tag_params['overlayOpacity'] ) {
								$_tag_params['overlay_opacity'] = $_tag_params['overlayOpacity'];
								unset( $_tag_params['overlayOpacity'] );
							}
						}
						
						// Set a dummy link to work with
						$_link = '<a href="'.$_tag_params['href'].'">'.$match[3].'</a>';
						// Modalize link
						if ( $this->params['doctype'] == 'html' ) {
							$_link = plgSystemModalizerHelper::modalizeLink( $_type, $_link, $_tag_params, 1 );
						}

						$str = str_replace( $match[0], $_link, $str );

					}
				}
			}
		}
		return $str;
	}
	
	function changeTagsByContent( $str = '', $tagcontent = '' ) 
	{
		if ( $str && $tagcontent && !( strpos( $str, $tagcontent ) === false ) )
		{
			$_regex = '#<([[:alnum:]_-]+?)\s[^>]*?'.preg_quote( $tagcontent, '#' ).'.+?>.*?</\1>#si';
			$str = preg_replace( $_regex, '', $str );
		}

		return $str;
	}
	
	function changeUrlByTagname( $str = '', $tagname = 'a', $tagparam = 'href' )
	{
		if ( $str && !( strpos( $str, '<'.$tagname ) === false ) ) {
			$_regex = '#<'.preg_quote( $tagname, '#' ).'\s+((?=^>*?)\s+)?'.preg_quote( $tagparam, '#' ).'\s*=\s*([\'"])(.*?)\2#s';
			if ( preg_match_all( $_regex, $str, $_matches, PREG_SET_ORDER ) > 0 ) {
				foreach ( $_matches as $_match ) {
					$_url = $_match[3];
					$is_internal = plgSystemModalizerHelper::urlIsInternal( $_url );
					if ( $is_internal ) {
						$_url = plgSystemModalizerHelper::setUrlDefaults( $_url );
						$_new_tag = '<'.$tagname.' '.$tagparam.'="'.$_url.'" '.$_match[1];
						$str = str_replace( $_match[0], $_new_tag, $str );
					}
				}
			}
		}

		return $str;
	}

	function modalizeLinks( $str = '' )
	{
		if ( $str ) {
			// Get all links
			$_regex = '#<a\s[^>]*?href=.*?</a>#si';
			if ( preg_match_all( $_regex, $str, $_matches, PREG_SET_ORDER ) > 0 ) {
				foreach ( $_matches as $_match ) {
					$_link_attribs = plgSystemModalizerHelper::getTagAttribs( $_match[0], 'a' );
					// only if link has a href and is not already changed by modelinks
					if( isset( $_link_attribs['href'] ) && ( !isset( $_link_attribs['rev'] ) || $_link_attribs['rev'] != 'ml' ) ) {
						$_url = $_link_attribs['href'];
						$_link = $_match[0];
						if ( plgSystemModalizerHelper::checkUrlIconType( $_url, 'email' ) ) {
							// Email Link
							if ( $this->_params->get( 'email_enable', 1 ) ) {
								$_link = plgSystemModalizerHelper::modalizeIconLink( $_link, 'email' );
							}
						} else if ( plgSystemModalizerHelper::checkUrlIconType( $_url, 'pdf' ) ) {
							// PDF Link
							if ( $this->_params->get( 'pdf_enable', 1 ) ) {
								$_link = plgSystemModalizerHelper::modalizeIconLink( $_link, 'pdf' );
							}
						} else if ( plgSystemModalizerHelper::checkUrlIconType( $_url, 'print' ) ) {
							// Print Link
							if ( $this->_params->get( 'print_enable', 1 ) ) {
								$_link = plgSystemModalizerHelper::modalizeIconLink( $_link, 'print' );
							}
						} else {
							$_class ='';
							if( isset( $_link_attribs['class'] ) ) {
								$_class = $_link_attribs['class'];
							}							
							if ( $this->params['enable_classes'] && plgSystemModalizerHelper::passClassCheck( $_class ) ) {
								// Class Link								
								$_link = plgSystemModalizerHelper::modalizeClassLink( $_link );
							} else if ( $this->params['enable_blank'] && plgSystemModalizerHelper::passBlankCheck( $_link ) ) {
								// Links with target=_blank
								$_link = plgSystemModalizerHelper::modalizeBlankLink( $_link );
							}
						}
						$str = str_replace( $_match[0], $_link, $str );
					}
				}
			}
		}

		return $str;
	}

	function arrayFilterEmpty( $array = array() )
	{
		// remove empty values
		return array_diff( $array, array('') );
	}

	function stringProtectorForward( $str )
	{
		$_search_regex = $this->params['protect_start'].'(.*?)'.$this->params['protect_end'];
		$_search_regex = '#'.$_search_regex.'#s';

		if ( preg_match_all( $_search_regex, $str, $_matches, PREG_SET_ORDER) > 0 ) {
			foreach ( $_matches as $_match ) {
				$_protected_match = base64_encode( $this->params['protect_start'] ).base64_encode( $_match['1'] ).base64_encode( $this->params['protect_end']);
				$_protected_match = '<|'.$_protected_match.'|>';;
				$str = str_replace( $_match['0'], $_protected_match, $str );
			}
		}
		return $str;
	}

	function stringProtectorReverse( $str, $replacement = FALSE )
	{
		$_search_regex = base64_encode( $this->params['protect_start'] ).'(.*?)'.base64_encode( $this->params['protect_end'] );
		$_search_regex = '\<\|'.$_search_regex.'\|\>';;
		$_search_regex = '#'.$_search_regex.'#s';

		if ( preg_match_all( $_search_regex, $str, $_matches, PREG_SET_ORDER) > 0 ) {
			foreach ( $_matches as $_match ) {
				$_r = ( $replacement === FALSE ) ? base64_decode( $_match['1'] ) : $replacement;
				$str = str_replace( $_match['0'], $_r, $str );
			}
		}
		return $str;
	}
}